% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_create_asset}
\alias{datazone_create_asset}
\title{Creates an asset in Amazon DataZone catalog}
\usage{
datazone_create_asset(
  clientToken = NULL,
  description = NULL,
  domainIdentifier,
  externalIdentifier = NULL,
  formsInput = NULL,
  glossaryTerms = NULL,
  name,
  owningProjectIdentifier,
  predictionConfiguration = NULL,
  typeIdentifier,
  typeRevision = NULL
)
}
\arguments{
\item{clientToken}{A unique, case-sensitive identifier that is provided to ensure the
idempotency of the request.}

\item{description}{Asset description.}

\item{domainIdentifier}{[required] Amazon DataZone domain where the asset is created.}

\item{externalIdentifier}{The external identifier of the asset.}

\item{formsInput}{Metadata forms attached to the asset.}

\item{glossaryTerms}{Glossary terms attached to the asset.}

\item{name}{[required] Asset name.}

\item{owningProjectIdentifier}{[required] The unique identifier of the project that owns this asset.}

\item{predictionConfiguration}{The configuration of the automatically generated business-friendly
metadata for the asset.}

\item{typeIdentifier}{[required] The unique identifier of this asset's type.}

\item{typeRevision}{The revision of this asset's type.}
}
\description{
Creates an asset in Amazon DataZone catalog.

See \url{https://www.paws-r-sdk.com/docs/datazone_create_asset/} for full documentation.
}
\keyword{internal}
