% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendra_operations.R
\name{kendra_create_data_source}
\alias{kendra_create_data_source}
\title{Creates a data source connector that you want to use with an Amazon
Kendra index}
\usage{
kendra_create_data_source(
  Name,
  IndexId,
  Type,
  Configuration = NULL,
  VpcConfiguration = NULL,
  Description = NULL,
  Schedule = NULL,
  RoleArn = NULL,
  Tags = NULL,
  ClientToken = NULL,
  LanguageCode = NULL,
  CustomDocumentEnrichmentConfiguration = NULL
)
}
\arguments{
\item{Name}{[required] A name for the data source connector.}

\item{IndexId}{[required] The identifier of the index you want to use with the data source
connector.}

\item{Type}{[required] The type of data source repository. For example, \code{SHAREPOINT}.}

\item{Configuration}{Configuration information to connect to your data source repository.

You can't specify the \code{Configuration} parameter when the \code{Type}
parameter is set to \code{CUSTOM}. If you do, you receive a
\code{ValidationException} exception.

The \code{Configuration} parameter is required for all other data sources.}

\item{VpcConfiguration}{Configuration information for an Amazon Virtual Private Cloud to connect
to your data source. For more information, see \href{https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html}{Configuring a VPC}.}

\item{Description}{A description for the data source connector.}

\item{Schedule}{Sets the frequency for Amazon Kendra to check the documents in your data
source repository and update the index. If you don't set a schedule
Amazon Kendra will not periodically update the index. You can call the
\code{\link[=kendra_start_data_source_sync_job]{start_data_source_sync_job}} API to
update the index.

Specify a \verb{cron-} format schedule string or an empty string to indicate
that the index is updated on demand.

You can't specify the \code{Schedule} parameter when the \code{Type} parameter is
set to \code{CUSTOM}. If you do, you receive a \code{ValidationException}
exception.}

\item{RoleArn}{The Amazon Resource Name (ARN) of an IAM role with permission to access
the data source and required resources. For more information, see \href{https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html}{IAM access roles for Amazon Kendra.}.

You can't specify the \code{RoleArn} parameter when the \code{Type} parameter is
set to \code{CUSTOM}. If you do, you receive a \code{ValidationException}
exception.

The \code{RoleArn} parameter is required for all other data sources.}

\item{Tags}{A list of key-value pairs that identify or categorize the data source
connector. You can also use tags to help control access to the data
source connector. Tag keys and values can consist of Unicode letters,
digits, white space, and any of the following symbols: _ . : / = + - @.}

\item{ClientToken}{A token that you provide to identify the request to create a data source
connector. Multiple calls to the
\code{\link[=kendra_create_data_source]{create_data_source}} API with the same
client token will create only one data source connector.}

\item{LanguageCode}{The code for a language. This allows you to support a language for all
documents when creating the data source connector. English is supported
by default. For more information on supported languages, including their
codes, see \href{https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html}{Adding documents in languages other than English}.}

\item{CustomDocumentEnrichmentConfiguration}{Configuration information for altering document metadata and content
during the document ingestion process.

For more information on how to create, modify and delete document
metadata, or make other content alterations when you ingest documents
into Amazon Kendra, see \href{https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html}{Customizing document metadata during the ingestion process}.}
}
\description{
Creates a data source connector that you want to use with an Amazon Kendra index.

See \url{https://www.paws-r-sdk.com/docs/kendra_create_data_source/} for full documentation.
}
\keyword{internal}
