% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_store_image_task}
\alias{ec2_create_store_image_task}
\title{Stores an AMI as a single object in an Amazon S3 bucket}
\usage{
ec2_create_store_image_task(
  ImageId,
  Bucket,
  S3ObjectTags = NULL,
  DryRun = NULL
)
}
\arguments{
\item{ImageId}{[required] The ID of the AMI.}

\item{Bucket}{[required] The name of the Amazon S3 bucket in which the AMI object will be stored.
The bucket must be in the Region in which the request is being made. The
AMI object appears in the bucket only after the upload task has
completed.}

\item{S3ObjectTags}{The tags to apply to the AMI object that will be stored in the Amazon S3
bucket.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Stores an AMI as a single object in an Amazon S3 bucket.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_store_image_task/} for full documentation.
}
\keyword{internal}
