% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelsv2_operations.R
\name{lexmodelsv2_list_intent_stage_metrics}
\alias{lexmodelsv2_list_intent_stage_metrics}
\title{Retrieves summary metrics for the stages within intents in your bot}
\usage{
lexmodelsv2_list_intent_stage_metrics(
  botId,
  startDateTime,
  endDateTime,
  metrics,
  binBy = NULL,
  groupBy = NULL,
  filters = NULL,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{botId}{[required] The identifier for the bot for which you want to retrieve intent stage
metrics.}

\item{startDateTime}{[required] The date and time that marks the beginning of the range of time for
which you want to see intent stage metrics.}

\item{endDateTime}{[required] The date and time that marks the end of the range of time for which you
want to see intent stage metrics.}

\item{metrics}{[required] A list of objects, each of which contains a metric you want to list, the
statistic for the metric you want to return, and the method by which to
organize the results.}

\item{binBy}{A list of objects, each of which contains specifications for organizing
the results by time.}

\item{groupBy}{A list of objects, each of which specifies how to group the results. You
can group by the following criteria:
\itemize{
\item \code{IntentStageName} – The name of the intent stage.
\item \code{SwitchedToIntent} – The intent to which the conversation was
switched (if any).
}}

\item{filters}{A list of objects, each of which describes a condition by which you want
to filter the results.}

\item{maxResults}{The maximum number of results to return in each page of results. If
there are fewer results than the maximum page size, only the actual
number of results are returned.}

\item{nextToken}{If the response from the ListIntentStageMetrics operation contains more
results than specified in the maxResults parameter, a token is returned
in the response.

Use the returned token in the nextToken parameter of a
ListIntentStageMetrics request to return the next page of results. For a
complete set of results, call the ListIntentStageMetrics operation until
the nextToken returned in the response is null.}
}
\description{
Retrieves summary metrics for the stages within intents in your bot. The following fields are required:

See \url{https://www.paws-r-sdk.com/docs/lexmodelsv2_list_intent_stage_metrics/} for full documentation.
}
\keyword{internal}
