% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_create_certificate_authority_audit_report}
\alias{acmpca_create_certificate_authority_audit_report}
\title{Creates an audit report that lists every time that your CA private key
is used to issue a certificate}
\usage{
acmpca_create_certificate_authority_audit_report(
  CertificateAuthorityArn,
  S3BucketName,
  AuditReportResponseFormat
)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) of the CA to be audited. This is of the
form:

\code{arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 }.}

\item{S3BucketName}{[required] The name of the S3 bucket that will contain the audit report.}

\item{AuditReportResponseFormat}{[required] The format in which to create the report. This can be either \strong{JSON} or
\strong{CSV}.}
}
\description{
Creates an audit report that lists every time that your CA private key is used to issue a certificate. The \code{\link[=acmpca_issue_certificate]{issue_certificate}} and \code{\link[=acmpca_revoke_certificate]{revoke_certificate}} actions use the private key.

See \url{https://www.paws-r-sdk.com/docs/acmpca_create_certificate_authority_audit_report/} for full documentation.
}
\keyword{internal}
