% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudhsm_operations.R
\name{cloudhsm_create_hsm}
\alias{cloudhsm_create_hsm}
\title{This is documentation for AWS CloudHSM Classic}
\usage{
cloudhsm_create_hsm(
  SubnetId,
  SshKey,
  EniIp = NULL,
  IamRoleArn,
  ExternalId = NULL,
  SubscriptionType,
  ClientToken = NULL,
  SyslogIp = NULL
)
}
\arguments{
\item{SubnetId}{[required] The identifier of the subnet in your VPC in which to place the HSM.}

\item{SshKey}{[required] The SSH public key to install on the HSM.}

\item{EniIp}{The IP address to assign to the HSM's ENI.

If an IP address is not specified, an IP address will be randomly chosen
from the CIDR range of the subnet.}

\item{IamRoleArn}{[required] The ARN of an IAM role to enable the AWS CloudHSM service to allocate an
ENI on your behalf.}

\item{ExternalId}{The external ID from \code{IamRoleArn}, if present.}

\item{SubscriptionType}{[required]}

\item{ClientToken}{A user-defined token to ensure idempotence. Subsequent calls to this
operation with the same token will be ignored.}

\item{SyslogIp}{The IP address for the syslog monitoring server. The AWS CloudHSM
service only supports one syslog monitoring server.}
}
\description{
This is documentation for \strong{AWS CloudHSM Classic}. For more information, see \href{https://aws.amazon.com/cloudhsm/faqs/}{AWS CloudHSM Classic FAQs}, the AWS CloudHSM Classic User Guide, and the \href{https://docs.aws.amazon.com/cloudhsm/classic/APIReference/}{AWS CloudHSM Classic API Reference}.

See \url{https://www.paws-r-sdk.com/docs/cloudhsm_create_hsm/} for full documentation.
}
\keyword{internal}
