% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verifiedpermissions_operations.R
\name{verifiedpermissions_update_policy_template}
\alias{verifiedpermissions_update_policy_template}
\title{Updates the specified policy template}
\usage{
verifiedpermissions_update_policy_template(
  policyStoreId,
  policyTemplateId,
  description = NULL,
  statement
)
}
\arguments{
\item{policyStoreId}{[required] Specifies the ID of the policy store that contains the policy template
that you want to update.}

\item{policyTemplateId}{[required] Specifies the ID of the policy template that you want to update.}

\item{description}{Specifies a new description to apply to the policy template.}

\item{statement}{[required] Specifies new statement content written in Cedar policy language to
replace the current body of the policy template.

You can change only the following elements of the policy body:
\itemize{
\item The \code{action} referenced by the policy template.
\item Any conditional clauses, such as \code{when} or \code{unless} clauses.
}

You \strong{can't} change the following elements:
\itemize{
\item The effect (\code{permit} or \code{forbid}) of the policy template.
\item The \code{principal} referenced by the policy template.
\item The \code{resource} referenced by the policy template.
}}
}
\description{
Updates the specified policy template. You can update only the description and the some elements of the \href{https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyTemplate.html#amazonverifiedpermissions-UpdatePolicyTemplate-request-policyBody}{policyBody}.

See \url{https://www.paws-r-sdk.com/docs/verifiedpermissions_update_policy_template/} for full documentation.
}
\keyword{internal}
