% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{generateSingleFactorItems}
\alias{generateSingleFactorItems}
\title{Generate paired comparison data with a common factor that
accounts for some proportion of the variance}
\usage{
generateSingleFactorItems(df, prop, th = 0.5, name, ..., scale = 1, alpha = 1)
}
\arguments{
\item{df}{a data frame with pairs of vertices given in columns \code{pa1} and \code{pa2}, and item response data in other columns}

\item{prop}{the number of items or a vector of signed proportions of variance}

\item{th}{a vector of thresholds}

\item{name}{a vector of item names}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{scale}{a vector of scaling constants}

\item{alpha}{a vector of item discriminations}
}
\value{
The given data.frame \code{df} with additional columns for each item.
}
\description{
Imagine that there are people that play in tournaments of more than
one board game. For example, the computer player AlphaZero (Silver
et al. 2018) has trained to play chess, shogi, and Go. We can take
the tournament match outcome data and find rankings among the
players for each of these games. We may also suspect that there is
a latent board game skill that accounts for some proportion of the
variance in the per-board game rankings.
}
\section{Response model}{


See \link{cmp_probs} for details.
}

\section{Backward incompatibility}{

The function \link{generateFactorItems} was renamed to
  \code{generateSingleFactorItems} (version 1.1.0) to make space for a more
  flexible factor model with an arbitrary number of factors and
  arbitrary factor-to-item loading pattern. If you don't need this
  flexibility, you can call the old function \link{generateSingleFactorItems}.
}

\examples{
df <- twoLevelGraph(letters[1:10], 100)
df <- generateSingleFactorItems(df, 3)
}
\references{
Silver, D., Hubert, T., Schrittwieser, J., Antonoglou, I., Lai, M.,
Guez, A., ... & Lillicrap, T. (2018). A general reinforcement
learning algorithm that masters chess, shogi, and Go through
self-play. \emph{Science, 362}(6419), 1140-1144.
}
\seealso{
Other item generators: 
\code{\link{generateCovItems}()},
\code{\link{generateFactorItems}()},
\code{\link{generateItem}()}
}
\concept{item generators}
