% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{outlierTable}
\alias{outlierTable}
\title{List observations with Pareto values larger than a given threshold}
\usage{
outlierTable(data, x, threshold = 0.5)
}
\arguments{
\item{data}{a data list prepared for processing by Stan}

\item{x}{An object created by \code{\link[loo:loo]{loo}}}

\item{threshold}{threshold is the minimum k value to include}
}
\value{
A data.frame (one row per observation) with the following columns:
\describe{
\item{pa1}{Name of object 1}
\item{pa2}{Name of object 2}
\item{item}{Name of item}
\item{pick}{Observed response}
\item{k}{Associated Pareto k value}
}
}
\description{
The function \code{\link{prepCleanData}} compresses observations
into the most efficient format for evaluation by Stan. This function
maps indices of observations back to the actual observations,
filtering by the largest Pareto k values. It is assumed that
\code{data} was processed by \code{\link{normalizeData}} or is in
the same order as seen by \code{\link{prepCleanData}}.
}
\examples{
palist <- letters[1:10]
df <- twoLevelGraph(palist, 300)
theta <- rnorm(length(palist))
names(theta) <- palist
df <- generateItem(df, theta, th=rep(0.5, 4))

df <- filterGraph(df)
df <- normalizeData(df)
dl <- prepCleanData(df)
dl$scale <- 1.5

\donttest{
m1 <- pcStan("unidim_ll", dl)

loo1 <- toLoo(m1, cores=1)
ot <- outlierTable(dl, loo1, threshold=.2)
df[df$pa1==ot[1,'pa1'] & df$pa2==ot[1,'pa2'], 'i1']
}
}
\seealso{
\code{\link{toLoo}}, \code{\link[loo:pareto-k-diagnostic]{pareto_k_ids}}
}
