% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoSamples.R
\name{twoSamples}
\alias{twoSamples}
\title{Permutatation-based two sample t-test}
\usage{
twoSamples(X, B = 1000, seed = 1234, 
permReturn = TRUE, label = NULL)
}
\arguments{
\item{X}{data matrix where columns represent the \code{m} variables and rows the \code{n} observations. The columns' name defines the groups' label.}

\item{B}{numeric value, number of permutations to be performed, including the identity. Default is 1000.}

\item{seed}{numeric value, specify seed. Default is 1234.}

\item{permReturn}{logical value, \code{TRUE} to return the t-tests and p-values permutation distribution. Default is \code{TRUE}.}

\item{label}{by default \code{label = NULL}. Labels of the observations, if \code{NULL} the rows's name are considered. D}
}
\value{
Returns a matrix objects:
\describe{ 
  \item{Test}{Matrix with dimensions \eqn{m x B} of permuted two-samples t-tests. The first column is the observed one-sample t-tests.}}
  if \code{permReturn = TRUE} otherwise returns:
\describe{ 
  \item{Test}{Vector of \eqn{m} observed two-samples t-tests}}
}
\description{
Performs two-sample t-tests by permutations.
}
\examples{
X <- matrix(rnorm(100*20), nrow=20)
rownames(X) <- c(rep(0, 10), rep(1,10))
out<- twoSamples(X = X) 
}
\author{
Angela Andreella
}
