% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_subgroups.R
\name{ped_subgroups}
\alias{ped_subgroups}
\alias{founders}
\alias{nonfounders}
\alias{leaves}
\alias{males}
\alias{females}
\alias{typedMembers}
\alias{untypedMembers}
\alias{father}
\alias{mother}
\alias{children}
\alias{spouses}
\alias{unrelated}
\alias{parents}
\alias{grandparents}
\alias{siblings}
\alias{nephews_nieces}
\alias{niblings}
\alias{piblings}
\alias{ancestors}
\alias{commonAncestors}
\alias{descendants}
\alias{commonDescendants}
\alias{descentPaths}
\title{Pedigree subgroups}
\usage{
founders(x, internal = FALSE)

nonfounders(x, internal = FALSE)

leaves(x, internal = FALSE)

males(x, internal = FALSE)

females(x, internal = FALSE)

typedMembers(x, internal = FALSE)

untypedMembers(x, internal = FALSE)

father(x, id, internal = FALSE)

mother(x, id, internal = FALSE)

children(x, id, internal = FALSE)

spouses(x, id, internal = FALSE)

unrelated(x, id, internal = FALSE)

parents(x, id, internal = FALSE)

grandparents(x, id, degree = 2, internal = FALSE)

siblings(x, id, half = NA, internal = FALSE)

nephews_nieces(x, id, removal = 1, half = NA, internal = FALSE)

niblings(x, id, half = NA, internal = FALSE)

piblings(x, id, half = NA, internal = FALSE)

ancestors(x, id, maxGen = Inf, inclusive = FALSE, internal = FALSE)

commonAncestors(x, ids, maxGen = Inf, inclusive = FALSE, internal = FALSE)

descendants(x, id, maxGen = Inf, inclusive = FALSE, internal = FALSE)

commonDescendants(x, ids, maxGen = Inf, inclusive = FALSE, internal = FALSE)

descentPaths(x, ids = founders(x), internal = FALSE)
}
\arguments{
\item{x}{A \code{\link[=ped]{ped()}} object or a list of such.}

\item{internal}{A logical indicating whether \code{id} (or \code{ids}) refers to the
internal order.}

\item{id, ids}{A character (or coercible to character) of one or more ID
labels. If \code{internal} is TRUE, \code{id} and \code{ids} should be positive integers.}

\item{degree, removal}{Non-negative integers.}

\item{half}{a logical or NA. If TRUE (resp. FALSE), only half (resp. full)
siblings/cousins/nephews/nieces are returned. If NA, both categories are
included.}

\item{maxGen}{The number of generations to include. Default: \code{Inf} (no
limit).}

\item{inclusive}{A logical indicating whether an individual should be counted
among his or her own ancestors/descendants}
}
\value{
The functions \code{founders}, \code{nonfounders}, \code{males}, \code{females}, \code{leaves}
each return a vector containing the IDs of all pedigree members with the
wanted property. (Recall that a founder is a member without parents in the
pedigree, and that a leaf is a member without children in the pedigree.)

The functions \code{father}, \code{mother}, \code{parents}, \code{children}, \code{siblings},
\code{grandparents}, \code{spouses}, \code{niblings} (nephews + nieces), \code{piblings} (aunts
\itemize{
\item uncles) and \code{unrelated}, each returns a vector naming all
pedigree members with the specified relationship to \code{id}.
}

The commands \code{ancestors(x, id)} and \code{descendants(x, id)} return vectors
containing the IDs of all ancestors (resp. descendants) of the individual
\code{id} within the pedigree \code{x}. If \code{inclusive = TRUE}, \code{id} is included in
the output, otherwise not. To cut off at a specific number of generations,
use \code{maxGen}.

For \code{commonAncestors(x, ids)} and \code{commonDescendants(x, ids)}, the output
is a vector containing the IDs of common ancestors (descendants) to all of
\code{ids}.

Finally, \code{descentPaths(x, ids)} returns a list of lists, containing all
pedigree paths descending from each individual in \code{ids} (by default all
founders).
}
\description{
A collection of utility functions for identifying pedigree members with
certain properties.
}
\examples{

x = ped(id = 2:9,
        fid = c(0,0,2,0,4,4,0,2),
        mid = c(0,0,3,0,5,5,0,8),
        sex = c(1,2,1,2,1,2,2,2))

spouses(x, id = 2) # 3, 8
children(x, 2)     # 4, 9
siblings(x, 4)     # 9 (full or half)
unrelated(x, 4)    # 5, 8
father(x, 4)       # 2
mother(x, 4)       # 3

siblings(x, 4, half = FALSE) # none
siblings(x, 4, half = TRUE)  # 9

niblings(x, 9) # 6, 7
niblings(x, 9, half = FALSE) # none

piblings(x, 6) # 9
piblings(x, 6, half = FALSE) # none

ancestors(x, 6)                               # 2, 3, 4, 5
ancestors(x, 6, maxGen = 2, inclusive = TRUE) # 4, 5, 6

descendants(x, 2)                                # 4, 6, 7, 9
descendants(x, 2, maxGen = 2, inclusive = TRUE)  # 2, 4, 9

leaves(x)          # 6, 7, 9
founders(x)        # 2, 3, 5, 8

}
\author{
Magnus Dehli Vigeland
}
