% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped.R
\name{validatePed}
\alias{validatePed}
\title{Pedigree errors}
\usage{
validatePed(x = NULL, id = NULL, fid = NULL, mid = NULL, sex = NULL)
}
\arguments{
\item{x}{A \code{ped} object.}

\item{id}{A character (or coercible to character) of individual ID labels.}

\item{fid, mid}{Vectors of the same length as \code{id}, naming each individual's
father and mother. Missing parents (of founders) may be entered as "0", ""
or NA.}

\item{sex}{A numeric of the same length as \code{id}, describing the genders of
the individuals (in the same order as \code{id}.) Each entry must be either 1
(=male), 2 (=female) or 0 (=unknown).}
}
\value{
If no errors are detected, the function returns NULL invisibly.
Otherwise, messages describing the errors are printed to the screen and an
error is raised.
}
\description{
Validate the internal pedigree structure. The input may be either a (possibly
malformed) \code{\link[=ped]{ped()}} object, or its defining vectors \code{id}, \code{fid}, \code{mid}, \code{sex}.
}
\examples{
x = nuclearPed()
validatePed(x)

# Various errors
# validatePed(id = c(1,2), fid = c(2,0), mid = c(0,1), sex = c(1,2))

}
