% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reliabilityDifferenceScore.R
\name{reliabilityOfDifferenceScore}
\alias{reliabilityOfDifferenceScore}
\title{Reliability of Difference Score.}
\usage{
reliabilityOfDifferenceScore(x, y, reliabilityX, reliabilityY)
}
\arguments{
\item{x}{Vector of one variable that is used in the computation of difference
score.}

\item{y}{Vector of second variable that is used in the computation of the
difference score.}

\item{reliabilityX}{The reliability of the \code{x} variable.}

\item{reliabilityY}{The reliability of the \code{y} variable.}
}
\value{
Reliability of the difference score that is computed from the difference of
\code{x} and \code{y}.
}
\description{
Estimate the reliability of a difference score.
}
\details{
Estimates the reliability of a difference score.
}
\examples{
v1 <- rnorm(1000, mean = 100, sd = 15)
v2 <- v1 + rnorm(1000, mean = 1, sd = 15)
reliabilityOfDifferenceScore(x = v1, y = v2,
 reliabilityX = .7, reliabilityY = .8)
}
\seealso{
Other reliability: 
\code{\link{repeatability}()}
}
\concept{reliability}
