% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightedQuantile.R
\name{kish_ess}
\alias{kish_ess}
\alias{wquantile_generic}
\alias{whdquantile}
\alias{wthdquantile}
\alias{wquantile}
\title{Weighted Quantiles.}
\usage{
kish_ess(w)

wquantile_generic(x, w, probs, cdf)

whdquantile(x, w, probs)

wthdquantile(x, w, probs, width = 1/sqrt(kish_ess(w)))

wquantile(x, w, probs, type = 7)
}
\arguments{
\item{w}{Numeric vector of weights to give each value. Should be the same
length as the vector of values.}

\item{x}{Numeric vector of values of which to determine the quantiles.}

\item{probs}{Numeric vector of the quantiles to retrieve.}

\item{cdf}{Cumulative distribution function.}

\item{width}{Numeric value for the width of the interval in the trimmed
Harrell-Davis quantile estimator.}

\item{type}{Numeric value for type of weighted quantile.}
}
\value{
Numeric vector of specified quantiles.
}
\description{
Computes weighted quantiles. \code{whdquantile()} uses a weighted
Harrell-Davis quantile estimator. \code{wthdquantile()} uses a weighted
trimmed Harrell-Davis quantile estimator. \code{wquantile()} uses a weighted
traditional quantile estimator.
}
\details{
Computes weighted quantiles according to Akinshin (2023).
}
\examples{
mydata <- c(1:100, 1000)
mydataWithNAs <- mydata
mydataWithNAs[c(1,5,7)] <- NA
weights <- rep(1, length(mydata))
quantiles <- c(0.01, 0.05, 0.1, 0.25, 0.5, 0.75, 0.9, 0.95, 0.99)

whdquantile(
  x = mydata,
  w = weights,
  probs = quantiles)

wthdquantile(
  x = mydata,
  w = weights,
  probs = quantiles)

wquantile(
  x = mydata,
  w = weights,
  probs = quantiles)

whdquantile(
  x = mydataWithNAs,
  w = weights,
  probs = quantiles)

wthdquantile(
  x = mydataWithNAs,
  w = weights,
  probs = quantiles)

wquantile(
  x = mydataWithNAs,
  w = weights,
  probs = quantiles)

}
\seealso{
\doi{10.48550/arXiv.2304.07265}

Other computations: 
\code{\link{Mode}()},
\code{\link{meanSum}()},
\code{\link{mySum}()}
}
\concept{computations}
