% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phinterval.R
\name{phinterval-accessors}
\alias{phinterval-accessors}
\alias{phint_start}
\alias{phint_start.default}
\alias{phint_start.Interval}
\alias{phint_start.phinterval}
\alias{phint_end}
\alias{phint_end.default}
\alias{phint_end.Interval}
\alias{phint_end.phinterval}
\alias{phint_starts}
\alias{phint_starts.default}
\alias{phint_starts.Interval}
\alias{phint_starts.phinterval}
\alias{phint_ends}
\alias{phint_ends.default}
\alias{phint_ends.Interval}
\alias{phint_ends.phinterval}
\title{Accessors for the endpoints of a phinterval}
\usage{
phint_start(phint)

\method{phint_start}{default}(phint)

\method{phint_start}{Interval}(phint)

\method{phint_start}{phinterval}(phint)

phint_end(phint)

\method{phint_end}{default}(phint)

\method{phint_end}{Interval}(phint)

\method{phint_end}{phinterval}(phint)

phint_starts(phint)

\method{phint_starts}{default}(phint)

\method{phint_starts}{Interval}(phint)

\method{phint_starts}{phinterval}(phint)

phint_ends(phint)

\method{phint_ends}{default}(phint)

\method{phint_ends}{Interval}(phint)

\method{phint_ends}{phinterval}(phint)
}
\arguments{
\item{phint}{\verb{[phinterval / Interval]}

A \verb{<phinterval>} or \verb{<Interval>} vector.}
}
\value{
For \code{phint_start()} and \code{phint_end()}, a \verb{<POSIXct>} vector the same length
as \code{phint}.

For \code{phint_starts()} and \code{phint_ends()}, a list of \verb{<POSIXct>} vectors the
same length as \code{phint}.
}
\description{
\code{phint_start()} and \code{phint_end()} return the earliest and latest endpoint
of each phinterval element, respectively. Holes (empty time spans) are
returned as \code{NA}.

\code{phint_starts()} and \code{phint_ends()} return lists of all start and end points
for each phinterval element, respectively. For phintervals with multiple
disjoint spans, each span's endpoint is included. Holes are returned as
length-0 \verb{<POSIXct>} vectors.
}
\examples{
int1 <- interval(as.Date("2020-01-10"), as.Date("2020-02-01"))
int2 <- interval(as.Date("2023-05-02"), as.Date("2023-06-03"))

phint_start(int1)
phint_end(int1)

# Holes have no endpoints; disjoint phintervals have multiple endpoints
hole <- phint_intersect(int1, int2)
disjoint <- phint_union(int1, int2)

phint_start(c(hole, disjoint))
phint_starts(c(hole, disjoint))

phint_end(c(hole, disjoint))
phint_ends(c(hole, disjoint))

# phint_start() and phint_end() return the minimum and maximum endpoints
negative <- interval(as.Date("1980-01-01"), as.Date("1979-12-27"))
phint_start(negative)
phint_end(negative)
}
