% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rast.ed.ses.R
\name{rast.ed}
\alias{rast.ed}
\title{Calculate Evolutionary distinctiveness for raster data}
\usage{
rast.ed(
  x,
  tree,
  edge.path,
  branch.length,
  n.descen,
  full_tree_metr = TRUE,
  filename = "",
  ...
)
}
\arguments{
\item{x}{SpatRaster. A SpatRaster containing presence-absence data (0 or 1)
for a set of species. The layers (species) will be sorted according to the
tree order. See the phylo.pres function.}

\item{tree}{phylo. A dated tree.}

\item{edge.path}{matrix. Matrix representing the paths through the tree from
root to each tip. See \code{\link{phylo.pres}}}

\item{branch.length}{numeric. A Named numeric vector of branch length for
each species. See \code{\link{phylo.pres}}}

\item{n.descen}{numeric. A Named numeric vector of number of descendants for
each branch. See \code{\link{phylo.pres}}}

\item{full_tree_metr}{logical. Whether edge.path, branch length and number
of descendants should be calculated with the full (TRUE) or the prunned tree
(FALSE). The default is TRUE.}

\item{filename}{character. Output filename}

\item{...}{additional arguments passed for terra::app}
}
\value{
SpatRaster
}
\description{
This function calculates evolutionary distinctiveness according
to the fair-proportion index. The values represents the mean ED for species
presents in each raster cell.
}
\examples{
\donttest{
library(terra)
library(phyloraster)
x <- rast(system.file("extdata", "rast.presab.tif",
package="phyloraster"))
# phylogenetic tree
tree <- ape::read.tree(system.file("extdata", "tree.nex",
package="phyloraster"))
data <- phylo.pres(x[[1:3]], tree)
ed <- rast.ed(data$x, edge.path = data$edge.path,
              branch.length = data$branch.length,
              n.descen = data$n.descen)
plot(ed)
}
}
\references{
Isaac, N. J., Turvey, S. T., Collen, B., Waterman, C. and
Baillie,
J. E. (2007). Mammals on the EDGE: conservation priorities based on threat
and phylogeny. PLoS ONE 2, e296.
}
\author{
Neander Marcel Heming and Gabriela Alves-Ferreira
}
