% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphtest-functions.R
\name{new_fortify.igraph}
\alias{new_fortify.igraph}
\title{Fortify method for networks of class \code{\link[igraph:igraph-package]{igraph}}}
\usage{
new_fortify.igraph(
  model,
  data = NULL,
  layout = igraph::nicely(),
  arrow.gap = ifelse(igraph::is.directed(model), 0.025, 0),
  by = NULL,
  scale = TRUE,
  stringsAsFactors = getOption("stringsAsFactors", FALSE),
  ...
)
}
\arguments{
\item{model}{an object of class \code{\link[igraph:igraph-package]{igraph}}.}

\item{data}{not used by this method.}

\item{layout}{a function call to an
\code{\link[igraph:igraph-package]{igraph}} layout function, such as
\code{\link[igraph]{layout_nicely}} (the default), or a 2 column matrix
giving the x and y coordinates for the vertices.
See \code{\link[igraph]{layout_}} for details.}

\item{arrow.gap}{a parameter that will shorten the network edges in order to
avoid overplotting edge arrows and nodes; defaults to \code{0} when the
network is undirected (no edge shortening), or to \code{0.025} when the
network is directed. Small values near \code{0.025} will generally achieve
good results when the size of the nodes is reasonably small.}

\item{by}{a character vector that matches an edge attribute, which will be
used to generate a data frame that can be plotted with
\code{\link[ggplot2]{facet_wrap}} or \code{\link[ggplot2]{facet_grid}}. The
nodes of the network will appear in all facets, at the same coordinates.
Defaults to \code{NULL} (no faceting).}

\item{scale}{whether to (re)scale the layout coordinates. Defaults to
\code{TRUE}, but should be set to \code{FALSE} if \code{layout} contains
meaningful spatial coordinates, such as latitude and longitude.}

\item{stringsAsFactors}{whether vertex and edge attributes should be
converted to factors if they are of class \code{character}. Defaults to
the value of \code{getOption("stringsAsFactors")}, which is \code{FALSE}
by default: see \code{\link[base]{data.frame}}.}

\item{...}{additional parameters for the \code{\link[igraph]{layout_}} function}
}
\value{
a \code{\link[base]{data.frame}} object.
}
\description{
This is copied with very slight modification from
https://github.com/briatte/ggnetwork/blob/master/R/fortify-igraph.R,
as that version is not on CRAN yet.
}
