% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R
\name{pipe_append_to_step_names}
\alias{pipe_append_to_step_names}
\title{Append string to all step names}
\usage{
pipe_append_to_step_names(pip, postfix, sep = ".")
}
\arguments{
\item{pip}{\code{Pipeline} object}

\item{postfix}{\code{string} to be appended to each step name.}

\item{sep}{\code{string} separator between step name and postfix.}
}
\value{
returns the \code{Pipeline} object invisibly
}
\description{
Appends string to all step names and takes care
of updating step dependencies accordingly.
}
\examples{
p <- pipe_new("pipe")
pipe_add(p, "step1", \(x = 1) x)
pipe_add(p, "step2", \(y = 1) y)
pipe_append_to_step_names(p, "new")
p
pipe_append_to_step_names(p, "foo", sep = "__")
p
}
