% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R
\name{pipe_run}
\alias{pipe_run}
\title{Run pipeline}
\usage{
pipe_run(
  pip,
  force = FALSE,
  recursive = TRUE,
  cleanUnkept = FALSE,
  progress = NULL,
  showLog = TRUE
)
}
\arguments{
\item{pip}{\code{Pipeline} object}

\item{force}{\code{logical} if \code{TRUE} all steps are run regardless of
whether they are outdated or not.}

\item{recursive}{\code{logical} if \code{TRUE} and a step returns a new
pipeline, the run of the current pipeline is aborted and the
new pipeline is run recursively.}

\item{cleanUnkept}{\code{logical} if \code{TRUE} all output that was not
marked to be kept is removed after the pipeline run. This option
can be useful if temporary results require a lot of memory.}

\item{progress}{\code{function} this parameter can be used to provide a
custom progress function of the form \verb{function(value, detail)},
which will show the progress of the pipeline run for each step,
where \code{value} is the current step number and \code{detail} is the name
of the step.}

\item{showLog}{\code{logical} should the steps be logged during the
pipeline run?}
}
\value{
returns the \code{Pipeline} object invisibly
}
\description{
Runs all new and/or outdated pipeline steps.
}
\examples{
# Simple pipeline
p <- pipe_new("pipe", data = 1)
pipe_add(p, "add1", \(x = ~data, y = 1) x + y)
pipe_add(p, "add2", \(x = ~add1, z = 2) x + z)
pipe_add(p, "final", \(x = ~add1, y = ~add2) x * y, keepOut = TRUE)
p |> pipe_run() |> pipe_collect_out()
pipe_set_params(p, list(z = 4))  # outdates steps add2 and final
p

p |> pipe_run() |> pipe_collect_out()

pipe_run(p, cleanUnkept = TRUE)
p

# Recursive pipeline (for advanced users)
p <- pipe_new("pipe", data = 1)
pipe_add(p, "add1", \(x = ~data, y = 1) x + y)
pipe_add(p, "new_pipe", \(x = ~add1) {
    p2 <- pipe_new("new_pipe", data = x)
    pipe_add(p2, "add1", \(x = ~data) x + 1)
    pipe_add(p2, "add2", \(x = ~add1) x + 2, keepOut = TRUE)
  }
)
p |> pipe_run() |> pipe_collect_out()

# Run pipeline with progress bar
p <- pipe_new("pipe", data = 1)
pipe_add(p, "first step", \() Sys.sleep(0.5))
pipe_add(p, "second step", \() Sys.sleep(0.5))
pipe_add(p, "last step", \() Sys.sleep(0.5))
pb <- txtProgressBar(min = 1, max = pipe_length(p), style = 3)
fprogress <- function(value, detail) {
   setTxtProgressBar(pb, value)
}
pipe_run(p, progress = fprogress, showLog = FALSE)
}
