% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_or.R
\name{plot_or}
\alias{plot_or}
\title{Plot OR}
\usage{
plot_or(
  glm_model_results,
  conf_level = 0.95,
  confint_fast_estimate = FALSE,
  assumption_checks = TRUE
)
}
\arguments{
\item{glm_model_results}{Results from a binomial Generalised Linear Model (GLM), as produced by \code{\link[stats:glm]{stats::glm()}}.}

\item{conf_level}{Numeric value between 0.001 and 0.999 (default = 0.95) specifying the confidence level for the confidence interval.}

\item{confint_fast_estimate}{Boolean (default = \code{FALSE}) indicating whether to use a faster estimate of the confidence interval. Note: this assumes normally distributed data, which may not be suitable for your data.}

\item{assumption_checks}{Boolean (default = \code{TRUE}) indicating whether to conduct checks to ensure that the assumptions of logistic regression are met.}
}
\value{
The function returns an object of class \code{gg} and \code{ggplot}, which can be
customised and extended using various \code{ggplot2} functions.
}
\description{
Produces an Odds Ratio plot to visualise the results of a logistic regression
analysis.
}
\examples{
# Load required libraries
library(plotor)
library(datasets)
library(dplyr)
library(ggplot2)
library(stats)
library(forcats)
library(tidyr)

# Load the Titanic dataset
df <- datasets::Titanic |>
  as_tibble() |>
  # convert aggregated counts to individual observations
  filter(n > 0) |>
  uncount(weights = n) |>
  # convert character variables to factors
  mutate(across(where(is.character), as.factor))

# Perform logistic regression using `glm`
lr <- glm(
  data = df,
  family = 'binomial',
  formula = Survived ~ Class + Sex + Age
)

# Produce the Odds Ratio plot
plot_or(lr)
}
\seealso{
\itemize{
\item See vignette('using_plotor', package = 'plotor') for more details on usage.
\item More details and examples can be found on the website: \url{https://craig-parylo.github.io/plotor/index.html}
}
}
