% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{error_modelSel}
\alias{error_modelSel}
\title{Compute error in model selection with Approximate Bayesian Computation}
\usage{
error_modelSel(object, threshold = NA, print = TRUE)
}
\arguments{
\item{object}{a list created by the \code{\link[=sim_modelSel]{sim_modelSel()}} function, containing
results of a simulation study to evaluate the quality of model selection
with Approximate Bayesian Computation.}

\item{threshold}{numeric value between 0 and 1 representing the minimum
posterior probability of assignment.}

\item{print}{logical, if TRUE (default), then this function prints the mean
models probabilities.}
}
\value{
apart from directly displaying the results if print is TRUE, the
output object of this function is a list with the following elements:

\item{confusion.matrix}{the confusion matrix.}

\item{probs}{the mean model misclassification probabilities.}

\item{postmeans}{the mean model misclassification probabilities when each
model is correctly or incorrectly estimated.}
}
\description{
This function calculates the confusion matrix and the mean misclassification
probabilities of models from the output of the \code{\link[=sim_modelSel]{sim_modelSel()}} function.
}
\details{
It is also possible to define a \code{threshold} for the posterior model
probabilities. This threshold sets the minimum posterior probability of
assignment. Thus, a simulation where the posterior probability of any model
is below the threshold will not be assigned to a model and will instead be
classified as "unclear".
}
\examples{
# load the matrix with simulated parameter values
data(sumstats)

# select a random simulation to act as target just to test the function
target <- sumstats[10 ,]

# create a "fake" vector of model indices
# this assumes that half the simulations were from one model and the other half from other model
# this is not true but serves as an example of how to use this function
index <- c(rep("model1", nrow(sumstats)/2), rep("model2", nrow(sumstats)/2))

# perform a leave-one-out cross validation of model selection
mysim <- sim_modelSel(index = index, sumstats = sumstats, nval = 10, tol = 0.1)

# compute the confusion matrix and the mean misclassification probabilities
error_modelSel(object = mysim)

}
