% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{inverse_trans}
\alias{inverse_trans}
\title{Back-transform the parameters values}
\usage{
inverse_trans(y, min, max)
}
\arguments{
\item{y}{is the parameter vector (long vector of numbers from the
simulations). These are the values to be back-transformed.}

\item{min}{is the minimum value of the prior for this parameter.}

\item{max}{is the maximum value of the prior for this parameter.}
}
\value{
a numeric vector with the same length as \code{y} with the parameter
values back-transformed.
}
\description{
This function applies a back-transformation to the parameter values.
}
\details{
The back-transformation should be applied after parameter estimation using an
Approximate Bayesian Computation framework. It will return the parameter
values back to their original scale.
}
\keyword{internal}
