% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{mergepost}
\alias{mergepost}
\title{Merge posterior distributions}
\usage{
mergepost(target, global, post, a = 0.5, wtreg = NULL)
}
\arguments{
\item{target}{a matrix or a list with target mean sumstat, where each entry
corresponds to a vector of size n (n = number of summary statistics) with
the summary statistics of each subset of loci.}

\item{global}{numeric vector of size n with mean summary statistics across
all loci.}

\item{post}{list with sample of posterior obtained for each subset of loci.
Each entry of the list is a matrix where each line corresponds to an
accepted simulations (size S) and each column corresponds to a parameter.}

\item{a}{numeric value with the alpha parameter of the locfit function.}

\item{wtreg}{(optional) list with the weights of regression method. Each
entry of the list is a numeric vector with weights for each accepted
simulation (size S).}
}
\value{
list of locfit objects with the density of the posterior for each
parameter and of mean, mode and quantiles obtained using weighted
quantiles. The list has the following elements:

\item{merge}{obtained by simply merging all the posteriors into a single
one and fitting a local regression without any prior weighting.}

\item{merged_stat}{posterior point estimates for the corresponding merging
method, \code{merge}. This includes the median, mean, mode and various quantiles
of the posterior.}

\item{weighted}{each target was weighted by its distance to the \code{global}
summary statistics mean, giving more weight to the target subset of loci
with mean summary statistics closer to the mean across the genome.}

\item{weighted_stat}{posterior point estimates for the corresponding
merging method, \code{weighted}. This includes the median, mean, mode and
various quantiles of the posterior.}

\item{merge_reg}{each accepted point was weighted by its regression
weight.}

\item{merge_reg_stat}{posterior point estimates for the corresponding
merging method, \code{merge_reg}. This includes the median, mean, mode and
various quantiles of the posterior.}

\item{weighted_reg}{each target was weighted according to its distance to
the overall mean and each point was weighted by its regression weight.}

\item{weighted_reg_stat}{posterior point estimates for the corresponding
merging method, \code{weighted_reg}. This includes the median, mean, mode and
various quantiles of the posterior.}

Details about the output can be found at:
\url{https://aakinshin.net/posts/weighted-quantiles/} and
\url{https://www.rdocumentation.org/packages/reldist/versions/1.6-6/topics/wtd.quantile}
}
\description{
After using the \code{\link[=multipleABC]{multipleABC()}} function to perform parameter estimation with
Approximate Bayesian Computation for several targets, this function can be
used to merge the different posterior distributions.
}
\details{
The posterior density will be estimated after simply merging the posteriors
computed from all target subset of loci and after weighting the posterior of
each target by its distance to the overall summary statistic mean. In other
words, each posterior will be weighted according to the distance between the
mean summary statistics of the subset of loci for which that posterior was
computed and the mean across all loci, giving more weight to sets of loci
with a mean closer to the overall mean.

Additionally, if the regression weights are available, each accepted point
will be weighted by its regression weight and by distance of its associated
target. The combination of these weights will be used to merge the multiple
posteriors. The weighted mean, median, mode and quantiles will be computed
for each of these different posterior merging methods by using the
\code{\link[=weighted_stats]{weighted_stats()}} and \code{\link[=mode_locfit]{mode_locfit()}} functions. Note that this function
requires the package \pkg{locfit}.
}
\examples{
# load the matrix with parameter values
data(params)
# load the matrix with simulated parameter values
data(sumstats)
# load the matrix with the prior limits
data(limits)

# select some random simulations to act as target just to test the function
targets <- sumstats[c(11:20) ,]
# we should remove those random simulation from the sumstats and params matrices
sumstats <- sumstats[-c(11:20), ]; params <- params[-c(11:20), ]

# parameter estimation for multiple targets
myabc <- multipleABC(targets = targets, params = params, sumstats = sumstats, limits = limits,
tol = 0.01, method = "regression")

# select a random simulation to act as the global value of the summary statistics
# ideally this should be computed from the entirety of the observed data
global <- sumstats[50, ]

# merge the posterior distributions obtained in the previous step
mergepost(target = targets, global = global, post = myabc$adjusted, wtreg = myabc$weights)

}
