% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_simulations.R
\name{runSCRM}
\alias{runSCRM}
\title{Run scrm and obtain genotypes}
\usage{
runSCRM(commands, nDip, nPops, model)
}
\arguments{
\item{commands}{A character string containing the commands for the scrm
package. This string can be created using the \code{cmd2pops}, the \code{cmdSingle}
or the \code{cmdParallel} functions.}

\item{nDip}{An integer representing the total number of diploid individuals
to simulate. Note that scrm actually simulates haplotypes, so the number of
simulated haplotypes is double of this.}

\item{nPops}{An integer that informs of how many populations exist on the
model you are trying to run.}

\item{model}{Either "2pops", "Single" or "Parallel" indicating which model
should be simulated.}
}
\value{
a list with the simulated genotypes. Each entry is a different locus
and, for each locus, different rows represent different individuals and
each column is a different site.
}
\description{
This function will run the scrm package, according to the command line
supplied as input. It will also combine haplotypes into genotypes and
re-organize the output if the simulations were performed under a single
origin scenario. This is to ensure that the output of the four-population
models will always follow the same order: the two divergent ecotypes in the
first location, followed by the two divergent ecotypes in the second
location.
}
\examples{
# create a vector with parameter values for a two populations model
params <- createParams(Nref = c(25000, 25000), ratio = c(0.1, 3), pool = c(5, 250),
seq = c(0.0001, 0.001), split = c(0, 3), CW = c(1e-13, 1e-3), WC = c(1e-13, 1e-3),
bT = c(0, 0.2), model = "2pops")

# create the command line for the scrm package
cmds <- cmd2pops(parameters = params, nSites = 2000, nLoci = 10, nDip = 100, mutrate = 2e-8)

# run SCRM and obtain the genotypes
runSCRM(commands = cmds, nDip = 100, nPops = 2, model = "2pops")

}
