% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_portfolios.R
\name{add_performance}
\alias{add_performance}
\title{Add a new performance measure to backtests}
\usage{
add_performance(bt, name, fun, desired_direction = 1)
}
\arguments{
\item{bt}{Backtest results as produced by the function \code{\link{portfolioBacktest}}.}

\item{name}{String with name of new performance measure.}

\item{fun}{Function to compute new performance measure from any element returned by 
\code{\link{portfolioBacktest}}, e.g., \code{return}, \code{wealth}, and \code{w_bop}.}

\item{desired_direction}{Number indicating whether the new measure is desired to be larger (1),
which is the default, or smaller (-1).}
}
\value{
List with the portfolio backtest results, see \code{\link{portfolioBacktest}}.
}
\description{
Add a new performance measure to backtests
}
\examples{
\donttest{
library(portfolioBacktest)
data(dataset10)  # load dataset

# define your own portfolio function
EWP_portfolio <- function(dataset, ...) {
  N <- ncol(dataset$adjusted)
  return(rep(1/N, N))
}

# do backtest
bt <- portfolioBacktest(list("EWP" = EWP_portfolio), dataset10)

# add a new performance measure
bt <- add_performance(bt, name = "SR arithmetic", 
                      fun = function(return, ...) 
                               PerformanceAnalytics::SharpeRatio.annualized(return, 
                                                                            geometric = FALSE))
                               
bt <- add_performance(bt, name = "avg leverage", desired_direction = -1,
                      fun = function(w_bop, ...)
                               if(anyNA(w_bop)) NA else mean(rowSums(abs(w_bop))))
}

}
\author{
Daniel P. Palomar
}
