% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotsNtables.R
\name{backtestChartDrawdown}
\alias{backtestChartDrawdown}
\title{Chart of the drawdown for a single backtest}
\usage{
backtestChartDrawdown(
  bt,
  portfolios = names(bt),
  dataset_num = 1,
  type = c("ggplot2", "simple"),
  ...
)
}
\arguments{
\item{bt}{Backtest results as produced by the function \code{\link{portfolioBacktest}}.}

\item{portfolios}{String with portfolio names to be charted. 
Default charts all portfolios in the backtest.}

\item{dataset_num}{Dataset index to be charted. Default is \code{dataset_num = 1}.}

\item{type}{Type of plot. Valid options: \code{"ggplot2", "simple"}. Default is 
\code{"ggplot2"}.}

\item{...}{Additional parameters.}
}
\description{
Create chart of the drawdown for a single backtest
obtained with the function \code{\link{portfolioBacktest}}.
By default the chart is based on the package \code{ggplot2}, but the user can also 
specify a plot based on \code{PerformanceAnalytics}.
}
\examples{
\donttest{
library(portfolioBacktest)
data(dataset10)  # load dataset

# define your own portfolio function
quintile_portfolio <- function(data, ...) {
  X <- diff(log(data$adjusted))[-1]  
  N <- ncol(X)
  ranking <- sort(colMeans(X), decreasing = TRUE, index.return = TRUE)$ix
  w <- rep(0, N)
  w[ranking[1:round(N/5)]] <- 1/round(N/5)
  return(w)
}

# do backtest
bt <- portfolioBacktest(list("Quintile" = quintile_portfolio), dataset10,
                        benchmark = c("1/N", "index"))

# now we can chart
backtestChartDrawdown(bt)
}

}
\seealso{
\code{\link{summaryBarPlot}}, \code{\link{backtestBoxPlot}}, 
         \code{\link{backtestChartCumReturn}}, \code{\link{backtestChartStackedBar}}, \code{\link{backtestChartSharpeRatio}}
}
\author{
Daniel P. Palomar and Rui Zhou
}
