% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.logis_fe.R
\name{test.logis_fe}
\alias{test.logis_fe}
\title{Conduct hypothesis testing for provider effects from a fitted \code{logis_fe} object}
\usage{
\method{test}{logis_fe}(
  fit,
  parm,
  level = 0.95,
  test = "exact.poisbinom",
  score_modified = TRUE,
  null = "median",
  n = 10000,
  threads = 1,
  alternative = "two.sided",
  ...
)
}
\arguments{
\item{fit}{a model fitted from \code{logis_fe}.}

\item{parm}{specifies a subset of providers for which confidence intervals are to be given.
By default, all providers are included. The class of \code{parm} should match the class of the provider IDs.}

\item{level}{the confidence level during the hypothesis test, meaning a significance level of \eqn{1 - \text{level}}.
The default value is 0.95.}

\item{test}{a character string specifying the type of testing method to be conducted. The default is "exact.poisbinom".
\itemize{
\item{\code{"exact.poisbinom"}:} exact test based on Poisson-binomial distribution of \eqn{O_i|Z_i}.
\item{\code{"exact.bootstrap"}:} exact test based on bootstrap procedure.
\item{\code{"wald"}:} wald test.
\item{\code{"score"}:} score test.
}}

\item{score_modified}{a logical indicating whether to use the modified score test
ignoring the randomness of covariate coefficient for score teat (\code{"test = score"}). The default value is TRUE.}

\item{null}{a character string or a number specifying null hypotheses of fixed provider effects. The default is \code{"median"}.}

\item{n}{resample size for bootstrapping when (\code{"test = exact.bootstrap"}). The default value is 10,000.}

\item{threads}{an integer specifying the number of threads to use. The default value is 1.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of
\code{"two.sided"} (default), \code{"greater"}, or \code{"less"}.}

\item{\dots}{additional arguments that can be passed to the function.}
}
\value{
A data frame containing the results of the hypothesis test, with the following columns:
\item{flag}{a flagging indicator where \code{1} means statistically higher than expected
and \code{-1} means statistically lower than expected.}
\item{p-value}{the p-value of the hypothesis test.}
\item{stat}{the test statistic.}
\item{Std.Error}{The standard error of the provider effect estimate, included only when \code{test = "wald"}.}
}
\description{
Conduct hypothesis tests on provider effects and identify outlying providers for a fixed effect logistic model.
}
\details{
By default, the function uses the \code{"exact.poisbinom"} method.
The wald test is invalid for extreme providers (i.e. when provider effect goes to infinity).
For the score test, consider that when the number of tested providers is large,
refitting the models to get the restricted MLEs will take a long time.
Therefore, we use unrestricted MLEs to replace the restricted MLEs during the testing procedure by default.
However, the user can specify \code{score_modified = FALSE} to perform a standard score test.
}
\examples{
data(ExampleDataBinary)
outcome = ExampleDataBinary$Y
covar = ExampleDataBinary$Z
ProvID = ExampleDataBinary$ProvID
fit_fe <- logis_fe(Y = outcome, Z = covar, ProvID = ProvID, message = FALSE)
test(fit_fe, test = "score")

}
\references{
Wu, W, Yang, Y, Kang, J, He, K. (2022) Improving large-scale estimation and inference for profiling health care providers.
\emph{Statistics in Medicine}, \strong{41(15)}: 2840-2853.
\cr
}
