% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{clr_extract}
\alias{clr_extract}
\title{Extract Multiple Components}
\usage{
clr_extract(
  col,
  components = c("red", "green", "blue", "hue_hsl", "saturation", "lightness", "hue_hcl",
    "chroma", "luminance")
)
}
\arguments{
\item{col}{a color object or vector of any of the three kinds of R color
specifications, i.e., either a color name (as listed by colors()), a
hexadecimal string of the form "#rrggbb" or "#rrggbbaa" (see rgb), or a
positive integer i meaning palette()[i].}

\item{components}{character, components that should be extracted. See details
for allowed components.}
}
\value{
data.frame of components
}
\description{
Extract multiple color components at the same time.
}
\details{
The allowed values for `components` are

- red
- green
- blue
- hue_hsl
- saturation
- lightness
- hue_hcl
- chroma
- luminance

This function is to be preferred if you need to extract multiple components
at the same time, since it doesn't need repeat transformations.
}
\examples{
clr_extract(rainbow(10))

clr_extract(rainbow(10), c("hue_hsl", "saturation"))
}
\seealso{
Other Extraction: 
\code{\link{clr_extract_chroma}()},
\code{\link{clr_extract_hue}()},
\code{\link{clr_extract_red}()}
}
\concept{Extraction}
