% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_peptide_type.R
\name{assign_peptide_type}
\alias{assign_peptide_type}
\title{Assign peptide type}
\usage{
assign_peptide_type(
  data,
  aa_before = aa_before,
  last_aa = last_aa,
  aa_after = aa_after
)
}
\arguments{
\item{data}{a data frame containing at least information about the preceding and C-terminal
amino acids of peptides.}

\item{aa_before}{a character column in the \code{data} data frame that contains the preceding amino
acid as one letter code.}

\item{last_aa}{a character column in the \code{data} data frame that contains the C-terminal amino
acid as one letter code.}

\item{aa_after}{a character column in the \code{data} data frame that contains the following amino
acid as one letter code.}
}
\value{
A data frame that contains the input data and an additional column with the peptide
type information.
}
\description{
Based on preceding and C-terminal amino acid, the peptide type of a given peptide is assigned.
Peptides with preceeding and C-terminal lysine or arginine are considered fully-tryptic. If a
peptide is located at the N- or C-terminus of a protein and fulfills the criterium to be
fully-tryptic otherwise, it is also considered as fully-tryptic. Peptides that only fulfill the
criterium on one terminus are semi-tryptic peptides. Lastly, peptides that are not fulfilling
the criteria for both termini are non-tryptic peptides.
}
\examples{
data <- data.frame(
  aa_before = c("K", "S", "T"),
  last_aa = c("R", "K", "Y"),
  aa_after = c("T", "R", "T")
)

assign_peptide_type(data, aa_before, last_aa, aa_after)
}
