% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_median_intensities.R
\name{qc_median_intensities}
\alias{qc_median_intensities}
\title{Median run intensities}
\usage{
qc_median_intensities(
  data,
  sample,
  grouping,
  intensity,
  plot = TRUE,
  interactive = FALSE
)
}
\arguments{
\item{data}{a data frame that contains at least the input variables.}

\item{sample}{a character or factor column in the \code{data} data frame that contains the sample name.}

\item{grouping}{a character column in the \code{data} data frame that contains either precursor or
peptide identifiers.}

\item{intensity}{a numeric column in the \code{data} data frame that contains intensity values.
The intensity should be ideally log2 transformed, but also non-transformed values can be used.}

\item{plot}{a logical value that indicates whether the result should be plotted.}

\item{interactive}{a logical value that specifies whether the plot should be interactive
(default is FALSE).}
}
\value{
A plot that displays median intensity over all samples. If \code{plot = FALSE} a data
frame containing median intensities is returned.
}
\description{
Median intensities per run are returned either as a plot or a table.
}
\examples{
set.seed(123) # Makes example reproducible

# Create example data
data <- create_synthetic_data(
  n_proteins = 100,
  frac_change = 0.05,
  n_replicates = 3,
  n_conditions = 2,
  method = "effect_random"
)

# Calculate median intensities
qc_median_intensities(
  data = data,
  sample = sample,
  grouping = peptide,
  intensity = peptide_intensity_missing,
  plot = FALSE
)

# Plot median intensities
qc_median_intensities(
  data = data,
  sample = sample,
  grouping = peptide,
  intensity = peptide_intensity_missing,
  plot = TRUE
)
}
