% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeFDR.R
\name{computeFDRwithID}
\alias{computeFDRwithID}
\title{Compute FDR given a score}
\usage{
computeFDRwithID(score, ID, decoy = "REV_", larger_better = TRUE)
}
\arguments{
\item{score}{a vector with scores}

\item{ID}{- list with protein id's}

\item{decoy}{decoy pattern, default "REV_"}

\item{larger_better}{if larger score better than small (default TRUE), If small score better set FALSE}
}
\value{
list with ID, decoy_hit (indicates if decoy), score the search engine score,
FDR1 false discovery rate estimated using the method of Elias and Gygi; FDR2 - estimated using the method of Kell.
}
\description{
For more details and references see package vignette
\code{vignette("TargetDecoyFDR_Example", package = "prozor")}
}
\examples{
data(fdrSample)
# call constructor
#nrow(fdrSample)
#fdrSample <- dplyr::slice_sample(fdrSample, n = 40000)

#usethis::use_data(fdrSample, overwrite = TRUE)
fdr1 <- computeFDRwithID(fdrSample$score, fdrSample$proteinID, larger_better = FALSE)
names(fdr1)
plot(fdr1$score, fdr1$FPR,type="l",xlim=c(0,0.001), ylim=c(0,0.0002))
lines(fdr1$score, fdr1$qValue_FPR, col=2)
lines(fdr1$score, fdr1$SimpleFDR,type="l",col=4)
lines(fdr1$score, fdr1$qValue_SimpleFDR, col=5)


fdr1 <- computeFDRwithID(fdrSample$score2, fdrSample$proteinID, larger_better = TRUE)
names(fdr1)
plot(fdr1$score, fdr1$FPR,type="l", xlim=c(2.5,5),ylim=c(0,0.001))
lines(fdr1$score, fdr1$qValue_FPR, col=2)
lines(fdr1$score, fdr1$SimpleFDR,type="l",col=4)
lines(fdr1$score, fdr1$qValue_SimpleFDR, col=5)

}
