% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/puls.R
\name{find_split}
\alias{find_split}
\title{Find the Best Split}
\usage{
find_split(
  toclust.fd,
  frame_row,
  cloc,
  dist,
  dsubs,
  dsubsname,
  weights,
  minbucket,
  minsplit,
  spliton,
  method
)
}
\arguments{
\item{toclust.fd}{A functional data object (i.e., having class \code{fd}) created
from \code{fda} package. See \code{\link[fda:fd]{fda::fd()}}.}

\item{frame_row}{One row of the split tree as data frame.}

\item{cloc}{Vector of current cluster membership.}

\item{dist}{Distance matrix of all observations in the data.}

\item{dsubs}{Distance matrix calculated on each subregion. A
three-dimensional matrix.}

\item{dsubsname}{Subregion names.}

\item{weights}{(Currently unused) Weights on observations.}

\item{minbucket}{The minimum number of data points in one cluster allowed.}

\item{minsplit}{The minimum number of observations that must exist in a node
in order for a split to be attempted.}

\item{spliton}{Restrict the partitioning on a specific set of subregions.}

\item{method}{The clustering method you want to run in each subregion. Can be
chosen between \code{pam} and \code{ward}.}
}
\value{
The updated \code{frame_row} with the next split updated.
}
\description{
Find the best split in terms of reduction in inertia for the transferred
node, indicate by row. Find the terminal node with the greatest change in
inertia and bi-partition it.
}
\keyword{internal}
