% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imap.R
\name{imap}
\alias{imap}
\alias{imap_lgl}
\alias{imap_chr}
\alias{imap_int}
\alias{imap_dbl}
\alias{imap_vec}
\alias{iwalk}
\title{Apply a function to each element of a vector, and its index}
\usage{
imap(.x, .f, ...)

imap_lgl(.x, .f, ...)

imap_chr(.x, .f, ...)

imap_int(.x, .f, ...)

imap_dbl(.x, .f, ...)

imap_vec(.x, .f, ...)

iwalk(.x, .f, ...)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.f}{A function, specified in one of the following ways:
\itemize{
\item A named function, e.g. \code{paste}.
\item An anonymous function, e.g. \verb{\\(x, idx) x + idx} or
\code{function(x, idx) x + idx}.
\item A formula, e.g. \code{~ .x + .y}. You must use \code{.x} to refer to the
current element and \code{.y} to refer to the current index.
No longer recommended.
}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Wrap a function with \code{\link[=in_parallel]{in_parallel()}} to declare that it should be performed
in parallel. See \code{\link[=in_parallel]{in_parallel()}} for more details.
Use of \code{...} is not permitted in this context.}

\item{...}{Additional arguments passed on to the mapped function.

We now generally recommend against using \code{...} to pass additional
(constant) arguments to \code{.f}. Instead use a shorthand anonymous function:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{# Instead of
x |> map(f, 1, 2, collapse = ",")
# do:
x |> map(\\(x) f(x, 1, 2, collapse = ","))
}\if{html}{\out{</div>}}

This makes it easier to understand which arguments belong to which
function and will tend to yield better error messages.}
}
\value{
A vector the same length as \code{.x}.
}
\description{
\code{imap(x, ...)}, an indexed map, is short hand for
\code{map2(x, names(x), ...)} if \code{x} has names, or \code{map2(x, seq_along(x), ...)}
if it does not. This is useful if you need to compute on both the value
and the position of an element.
}
\examples{
imap_chr(sample(10), paste)

imap_chr(sample(10), \(x, idx) paste0(idx, ": ", x))

iwalk(mtcars, \(x, idx) cat(idx, ": ", median(x), "\n", sep = ""))
}
\seealso{
Other map variants: 
\code{\link{lmap}()},
\code{\link{map}()},
\code{\link{map2}()},
\code{\link{map_depth}()},
\code{\link{map_if}()},
\code{\link{modify}()},
\code{\link{pmap}()}
}
\concept{map variants}
