% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvEBayes_main_function.R
\name{calculate_tilde_e}
\alias{calculate_tilde_e}
\title{Estimate expected null baseline count based on reference row and column}
\usage{
calculate_tilde_e(contin_table)
}
\arguments{
\item{contin_table}{an IxJ contingency table showing pairwise counts of adverse
events for I AEs (along the rows) and J drugs (along the columns). The
reference row "Other AEs" and the reference column "Other drugs" need to be the
I-th row and J-th column respectively.}
}
\value{
an \code{nrow(contin_table)} by \code{ncol(contin_table)} matrix.
}
\description{
This function estimates the expected null baseline count (\eqn{E_{ij}}) for
each AE-drug combination under the assumption of independence between rows and
columns. The expected count is calculated using a reference row (other AEs)
and reference column (other drugs). This null baseline is typically used in
the empirical Bayes modeling of \code{pvEBayes} package for signal detection
and estimation in spontaneous reporting system (SRS) data.
}
\details{
This null value estimator is proposed by Tan et al. (2025).
}
\references{
Tan Y, Markatou M and Chakraborty S. Flexible Empirical Bayesian Approaches to
Pharmacovigilance for Simultaneous Signal Detection and Signal Strength Estimation
in Spontaneous Reporting Systems Data. \emph{arXiv preprint.} 2025; arXiv:2502.09816.
}
\keyword{internal}
