% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvEBayes_object_S3_methods.R
\name{posterior_draws}
\alias{posterior_draws}
\title{Generate posterior draws for each AE-drug combination}
\usage{
posterior_draws(obj, n_posterior_draws = 1000)
}
\arguments{
\item{obj}{a \code{pvEBayes} object, which is the output of the function
\link{pvEBayes} or \link{pvEBayes_tune}.}

\item{n_posterior_draws}{number of posterior draws for each AE-drug
combination.}
}
\value{
The function returns an S3 object of class \code{pvEBayes} with posterior draws.
}
\description{
This function generates posterior draws from the posterior distribution of
\eqn{\lambda_{ij}} for each AE-drug combination, based on a fitted empirical
Bayes model. The posterior draws can be used to compute credible intervals,
visualize posterior distributions, or support downstream inference.
}
\examples{

fit <- pvEBayes(
  contin_table = statin2025_44, model = "general-gamma",
  alpha = 0.3, n_posterior_draws = NULL
)

fit_with_draws <- posterior_draws(fit, n_posterior_draws = 1000)

}
