% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OsmoticPot.R
\name{OsmoticPot}
\alias{OsmoticPot}
\title{Pressure Volume Curve Analysis}
\usage{
OsmoticPot(
  data,
  sample = "sample",
  water.potential = "water.potential",
  RWD = "RWD",
  graph = TRUE,
  show.legend = TRUE
)
}
\arguments{
\item{data}{data frame containing columns of equal lengths giving the numerical
coordinates of the curve: water potential (MPa) and RWD (\%), ordered by sample by descending water potential. A
column containing the sample IDs is optionally required if several samples were measured.}

\item{sample}{optional column name in data containing the sample ID, default: "sample"}

\item{water.potential}{optional column name in data containing the numeric water potential values
(MPa), default: "water.potential"}

\item{RWD}{optional column name in data containing the relative water deficit values (\%), default: "RWD"}

\item{graph}{set FALSE if no plots are to be returned}

\item{show.legend}{set FALSE if no legend is to be shown in the plots}
}
\value{
List splitted by sample consisting of
\item{turgor.loss.point}{x and y coordinates of the turgor loss point (RWD (\%) and water.potential (MPa), respectively)}
\item{osmotic.potential}{x and y intercepts of the osmotic potential fit (apoplasic fraction (apo.fract) (\%) and op.full.sat (MPa), respectively)}
\item{formula}{formula of the linear osmotic potential fit}
\item{coef}{coefficients of the linear model}
\item{conf_int}{upper (97.5 \%) and lower (2.5 \%) border of 95 \% confidence interval of model parameters}
If graph = TRUE, the plotted tranformed data is displayed with the x- and y-axis
intercepts of the turgor loss point and the
linear regression line of the osmotic potential showing the point of y-intercept (op.full.sat) and x-intercept (apo.fract). \cr
Before using this function, check the raw data for an initial plateau. If the exponential decline does not onset directly,
fitting might not succeed.
}
\description{
Determines the coordinates of the turgor loss point, osmotic potential at full hydration
and apoplastic fraction
}
\details{
RWD at turgor loss point is derived by the function TurgorLossPoint(). \cr \cr
The pressure-volume curve data is converted to -1/MPa. The osmotic potential is then derived by fitting a linear
regression line with the Gauss-Newton algorithm of nls() to the water potential data following the turgor loss point. The y- and
x-axis intercept of the regression line gives the osmotic potential at full hydration (op.full.sat) and the RWD at zero 1/-Psi,
respectively. RWD at zero1/-Psi is then transferred to RWC at zero 1/-Psi to derive apoplastic fraction
(apo.fract). The turgor loss point equals the value of the osmotic potential fit at the relative
water deficit at turgor loss point. \cr \cr Before using this function, check the data for an initial plateau. Data points in the initial part of the water potential
versus RWD plot with a stronger then expected decline need to be omitted.
}
\examples{
# get example data, calculate Relative Water Deficit
data <- RelativeWaterDeficit(pressure_volume_data)[pressure_volume_data$sample == 10, ]

# calculate pressure volume curve characteristics and plot graphs
pv_analysis <- OsmoticPot(data)

}
