% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Transpiration.R
\name{Transpiration}
\alias{Transpiration}
\title{Leaf transpiration}
\usage{
Transpiration(data, sample = "sample", date.and.time = "date.and.time",
  fresh.weight = "fitted.fw", leaf.area = "leaf.area",
  output.unit = "mmol")
}
\arguments{
\item{data}{data frame with columns of equal length containg at least columns with the time (and date) of the fresh weight
measurements as well as columns with the measured fresh weights (g) and the single-sided leaf area (cm^2) of the sample. The
data is to be ordered chronologically by sample. A column containing the sample IDs is optionally required if several samples were measured.}

\item{sample}{optional name of the column in data containing the sample ID; default: "sample"}

\item{date.and.time}{optional name of the column in data containing the time of the fresh weight measurements
as class POSIXct; default: "date.and.time"}

\item{fresh.weight}{optional name of the column in data containing the numeric fresh weight values (g);
default: "fitted.fw"}

\item{leaf.area}{optional name of the column in data containing the numeric single-sided leaf area values (cm^2);
default: "leaf.area"}

\item{output.unit}{optional; possible values: "mg" or "mmol"; defines whether transpiration is given in
mmol m^-2 s^-1 (Default) or in mg m^-2 s^-1}
}
\value{
The original data frame extended by a numeric column with the transpiration
(mg s^-1 m^-2 or mmol s^-1 m^-2) of the double-sided leaf area. The first value of each sample is
NA, since transpiration values are computed from row i and i-1.
}
\description{
Calculates transpiration of a plant part from experimentally determined weight loss per time unit
and double-sided leaf area.
}
\details{
Transpiration (mmol s^-1 m^-2) is calculated as:
\deqn{T = \Delta FM * 1000 * (\Delta t * 60 * LA * 2 /10000 * 18.01528)^-1}
whereas T = transpiration, \eqn{\Delta}FW = reduction of fresh weight (g),
\eqn{\Delta}t = time unit (min), LA = single-sided leaf area (cm^2)
}
\examples{
# get example data and allocate
df <- WeatherAllocation(leaf_drying_data, weather_data)

# extend df by transpiration in mmol s^-1 m^-2
df_with_transpiration <- Transpiration(df, fresh.weight = "fresh.weight")

# extend df by transpiration in mg s^-1 m^-2
df_with_transpiration <- Transpiration(df, fresh.weight = "fresh.weight", output.unit = "mg")

}
