% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwsem.R
\name{pwSEM}
\alias{pwSEM}
\title{The pwSEM function}
\usage{
pwSEM(
  sem.functions,
  marginalized.latents = NULL,
  conditioned.latents = NULL,
  data,
  use.permutations = FALSE,
  n.perms = 5000,
  do.smooth = FALSE,
  all.grouping.vars = NULL
)
}
\arguments{
\item{sem.functions}{A list giving the gamm4 (gamm4 package) or gam (mgcv package) models associated with each
variable in the sem, INCLUDING exogenous variables.}

\item{marginalized.latents}{A list giving any dependent errors (correlated error variables), given
in the form of list(X~~Y,...,X~~Z). The same pair cannot also be listed in conditioned.latents.}

\item{conditioned.latents}{A list giving any implicitly conditioned latents (selection bias), given
in the form of list(X~~Y,...,X~~Z).  The same pair cannot also be listed in marginalized.latents.}

\item{data}{A data frame containing the empirical data}

\item{use.permutations}{A logical value (TRUE, FALSE) indicating if you
want to use permutation probabilities for the d-separation tests. Defaults
to FALSE. You should use TRUE for smaller data sets.}

\item{n.perms}{The number of permutation runs to use for permutation probabilities.
Defaults to 5000.}

\item{do.smooth}{A logical value indicating if you want to use regression
smoothers (generalized additive models) for the dsep tests.  Defaults to FALSE.
TRUE will fit nonlinear (regression smoothers) when evaluating the d-separation
claims, but this will slow down the function.}

\item{all.grouping.vars}{A character vector giving the names of all
variables involved in the sem functions that define groups for
random effects.}
}
\value{
A list containing the following elements:
causal.graph, dsep.equivalent.causal.graph, basis.set,
dsep.probs, sem.functions,C.statistic, prob.C.statistic,
AIC, n.data.lines, use.permutations, n.perms
}
\description{
This function performs a "piecewise" structural equation model without explicit latent variables
(a "path" model), including with implictly marginalized latents and
implicitly conditioned latents ("correlated errors"), based on generalized
linear or additive models, possibly in a mixed model context, and then tests
the causal structure against an empirical data set using a dsep test.  Therefore, it is able to
model linear, generalized linear, generalized linear mixed, additive, generalized additive, and
generalized additive mixed models.
}
\examples{

# Simulated data with correlated errors involving endogenous
# variables, normally-distributed data and with a 2-level grouping
# structure and using smoothing splines for the d-separation tests.
# Data generated using this mixed acyclic graph:
# X1->X2->X3->X4 and X2<->X4

my.list<-list(gamm4::gamm4(X1~1,random=~(1|group),data=sim_normal.with.nesting,family=gaussian),
         gamm4::gamm4(X2~X1,random=~(1|group),data=sim_normal.with.nesting,family=gaussian),
         gamm4::gamm4(X3~X2,random=~(1|group),data=sim_normal.with.nesting,family=gaussian),
         gamm4::gamm4(X4~X3,random=~(1|group),data=sim_normal.with.nesting,family=gaussian))
# RUN THE pwSEM FUNCTION WITH PERMUTATION PROBABILITIES AND INCLUDING THE DEPENDENT ERRORS
out<-pwSEM(sem.functions=my.list,marginalized.latents=list(X4~~X2),
          data=sim_normal.with.nesting,use.permutations = TRUE,
          do.smooth=TRUE,all.grouping.vars=c("group"))
summary(out,structural.equations=TRUE)

# see vignette("pwSEM")

}
