% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipysd.R
\name{get_timestep}
\alias{get_timestep}
\title{Gets the time step (DT) from the model}
\usage{
get_timestep(o)
}
\arguments{
\item{o}{is the ipysd S3 object}
}
\value{
The simulation time step
}
\description{
\code{get_timestep} uses pysd to fetch the time step from the model
}
\details{
As it's a generic function, this call is dispatched to set_component.isdpy
}
\examples{
\dontrun{
target <- system.file("models/vensim", "Population.mdl", package = "pysd2r")
py <- pysd_connect()
py <- read_vensim(py, target)
time_step  <- get_timestep(py)
}
}
