% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipysd.R
\name{set_components}
\alias{set_components}
\title{Changes a model parameter}
\usage{
set_components(o, vals)
}
\arguments{
\item{o}{is the ipysd S3 object}

\item{vals}{contains a list with the parameter and value to be changed}
}
\description{
\code{set_components()} calls \code{.set_components()} and changes
a resulting parameter in the model
}
\details{
As it's a generic function, this call is dispatched to set_component.isdpy
}
\examples{
\dontrun{
target <- system.file("models/vensim", "Population.mdl", package = "pysd2r")
py <- pysd_connect()
py <- read_vensim(py, target)
results <- run_model(py)
l <- list("Growth Fraction"=0.02)
set_components(py,l)
out2 <- run_model(py)
}
}
