% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FastKerFDR_functions.R
\name{FastKerFdr_unsigned}
\alias{FastKerFdr_unsigned}
\title{FastKerFdr unsigned}
\usage{
FastKerFdr_unsigned(
  X,
  p0 = NULL,
  plotting = FALSE,
  NbKnot = 1e+05,
  tol = 1e-05,
  max_iter = 10000
)
}
\arguments{
\item{X}{a vector of probit-transformed p-values (corresponding to a p-value serie)}

\item{p0}{a priori proportion of \eqn{H_0} hypotheses}

\item{plotting}{boolean, should some diagnostic graphs be plotted. (Default is FALSE.)}

\item{NbKnot}{The (maximum) number of knot for the \code{kde} procedure. (Default is 1e5.)}

\item{tol}{a tolerance value for convergence. (Default is 1e-5.)}

\item{max_iter}{the maximum number of iterations allowed for the algorithm to converge or complete its process.(Default is 1e4.)}
}
\value{
A list with the following elements:
\tabular{ll}{
\code{p0} \tab vector of  the estimated proportions of \eqn{H_0} hypotheses
for each of p-value serie. \cr
\code{tau} \tab the vector of \eqn{H_1} posteriors. \cr
\code{f1} \tab a numeric vector, each coordinate \eqn{i}
corresponding to the evaluation of the \eqn{H_1} density at point \eqn{x_i},
where \eqn{x_i} is the \eqn{i}th item in \code{X}. \cr
\code{F1} \tab  a numeric vector, each coordinate \eqn{i}
corresponding to the evaluation of the \eqn{H_1} cdf at point \eqn{x_i},
where \eqn{x_i} is the \eqn{i}th item in \code{X}.
}
}
\description{
Kernel estimation of the density in a two-components mixture model
where one component are a standard Gaussian density.
Here we suppose that the density to estimate lives in \eqn{R^+}.
}
