% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qx_functions.R
\name{qd_read}
\alias{qd_read}
\title{qd_read}
\usage{
qd_read(file,
         use_alt_rep = qopt("use_alt_rep"),
         validate_checksum = qopt("validate_checksum"),
         nthreads = qopt("nthreads"))
}
\arguments{
\item{file}{The file name/path.}

\item{use_alt_rep}{Use ALTREP when reading in string data (the initial value is FALSE).}

\item{validate_checksum}{Whether to validate the stored checksum in the file (the initial value is FALSE).}

\item{nthreads}{The number of threads to use when reading data (the initial value is 1L). When TBB is not available, values greater than 1 emit a warning and fall back to 1.}
}
\value{
The object stored in \code{file}.
}
\description{
Reads an object that was saved to disk in the \code{qdata} format.
}
\examples{
x <- data.frame(int = sample(1e3, replace=TRUE),
         num = rnorm(1e3),
         char = sample(state.name, 1e3, replace=TRUE),
         stringsAsFactors = FALSE)
myfile <- tempfile()
qd_save(x, myfile)
x2 <- qd_read(myfile)
identical(x, x2) # returns TRUE
}
