% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_assoc_metrics.R
\name{calculate_bigram_probabilities}
\alias{calculate_bigram_probabilities}
\title{Calculate Probabilities for Bigrams}
\usage{
calculate_bigram_probabilities(data, doc_index, token_index, type)
}
\arguments{
\item{data}{A data frame containing the corpus}

\item{doc_index}{Column name for document index}

\item{token_index}{Column name for token position}

\item{type}{Column name for the actual tokens/terms}
}
\value{
A data frame containing:
\itemize{
\item x: First token in bigram
\item y: Second token in bigram
\item p_xy: Joint probability of the bigram
\item p_x: Marginal probability of first token
\item p_y: Marginal probability of second token
}
}
\description{
Helper function that calculates joint and marginal probabilities for
bigrams in the input data using dplyr. It processes the data to create
bigrams and computes their probabilities along with individual token
probabilities.
}
\keyword{internal}
