% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QKResults_class.R
\name{predict.QKResults}
\alias{predict.QKResults}
\title{Revaluate Quantiles}
\usage{
\method{predict}{QKResults}(object, xnew, quantnew = NULL, ...)
}
\arguments{
\item{object}{Output from the quantKrig function.}

\item{xnew}{Locations for prediction}

\item{quantnew}{Quantiles for prediction, default is to keep the same as the quantile object}

\item{...}{Ignore. No other arguments for this method}
}
\value{
Quantile predictions at the specified input locations
}
\description{
Quantile Predictions using Quantile Kriging model (class QKResults)
}
\examples{

X <- seq(0,1,length.out = 20)
Y <- cos(5*X) + cos(X)
Xstar <- rep(X,each = 100)
Ystar <- rep(Y,each = 100)
e <- rchisq(length(Ystar),5)/5 - 1
Ystar <- Ystar + e
lb <- c(0.0001,0.0001)
ub <- c(10,10)
Qout <- quantKrig(Xstar,Ystar, seq(0.05,0.95, length.out = 7), lower = lb, upper = ub)

predict(Qout, xnew = c(0.4, 0.5, 0.6))

quantpreds <- predict(Qout, xnew = seq(0,1,length.out = 100), quantnew = seq(0.01,0.99,by = 0.01))
matplot(seq(0,1,length.out = 100), quantpreds, type = 'l')
}
\author{
Kevin Quinlan quinlan5@llnl.gov
}
