% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrices.R
\name{trdot}
\alias{trdot}
\title{The Trace Inner Product of Matrices}
\usage{
trdot(A, B)
}
\arguments{
\item{A, B}{square matrices.}
}
\value{
The trace inner product on \eqn{Mat_{n\ x\ n}(\mathbb{C})} is
defined as

\deqn{\langle A, B \rangle := tr(A^*B)}
}
\description{
Computes the trace inner product of two matrices \code{A} and \code{B}.
}
\examples{
A <- rbind(1:5, 2:6, 3:7)
B <- rbind(7:11, 8:12, 9:13)

# Compute the trace inner product of A and B
trdot(A, B)
}
\seealso{
\code{\link[=J]{J()}}, \code{\link[=tr]{tr()}}, \code{\link[=cartesian]{cartesian()}}
}
