% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_plot.R
\name{line_plot}
\alias{line_plot}
\title{Line Plots}
\usage{
line_plot(
  data,
  variables,
  index = NULL,
  version = r2spss_options$get("version"),
  ...
)
}
\arguments{
\item{data}{a data frame containing the variables to be plotted.}

\item{variables}{a character vector specifying at least one variable to be
plotted on the \eqn{y}-axis.  In case of multiple variables, separate lines
are drawn for each variable and a legend is shown.}

\item{index}{a character string specifying a variable to be plotted on the
\eqn{x}-axis, or \code{NULL} to plot the observations against their index.}

\item{version}{a character string specifying whether the plot should mimic
the look of recent SPSS versions (\code{"modern"}) or older versions (<24;
\code{"legacy"}).}

\item{\dots}{additional arguments to be passed down to
\code{\link[ggplot2]{geom_line}}.}
}
\value{
An object of class \code{"\link[ggplot2]{ggplot}"}, which produces
a line plot when printed.
}
\description{
Draw connected lines for variables in a data frame.  The plot thereby mimics
the look of SPSS graphs.
}
\examples{
# load data
data("Eredivisie")
# log-transform market values
Eredivisie$logMarketValue <- log(Eredivisie$MarketValue)

# aggregate log market values by position
means <- aggregate(Eredivisie[, "logMarketValue", drop = FALSE],
                   Eredivisie[, "Position", drop = FALSE],
                   FUN = mean)

# create profile plot
line_plot(means, "logMarketValue", "Position")

# easier and fancier as the plot method of ANOVA results
oneway <- ANOVA(Eredivisie, "logMarketValue",
                group = "Position")
plot(oneway)

}
\author{
Andreas Alfons
}
\keyword{hplot}
