% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4.3_Mix_designs_Functions.R
\name{contourPlot3}
\alias{contourPlot3}
\title{contourPlot3: Ternary plot}
\usage{
contourPlot3(
  x,
  y,
  z,
  response,
  data = NULL,
  main,
  xlab,
  ylab,
  zlab,
  form = "linear",
  col = 1,
  col.text,
  axes = TRUE,
  steps,
  plot = TRUE,
  show.scale = TRUE
)
}
\arguments{
\item{x}{Factor 1 of the \code{mixDesign} object.}

\item{y}{Factor 2 of the \code{mixDesign} object.}

\item{z}{Factor 3 of the \code{mixDesign} object.}

\item{response}{the response of the \code{mixDesign} object.}

\item{data}{The \code{mixDesign} object from which x,y,z and the response are taken.}

\item{main}{Character string specifying the main title of the plot.}

\item{xlab}{Character string specifying the label for the x-axis.}

\item{ylab}{Character string specifying the label for the y-axis.}

\item{zlab}{Character string specifying the label for the z-axis.}

\item{form}{A character string or a formula with the syntax `y ~ A + B + C`.
If form is a character string, it has to be one of the following:
\itemize{
\item{`linear`}
\item{`quadratic`}
}
How the form influences the output is described in the reference listed below.
By default, \code{form} is set to `linear`.}

\item{col}{A predefined value (1, 2, 3, or 4) or a self-defined \code{colorRampPalette} specifying the colors to be used in the plot.}

\item{col.text}{A character string specifying the color of the axis labels.
The default value \code{col.text} is '1'.}

\item{axes}{A logical value specifying whether the axes should be plotted.
By default, \code{axes} is set to \code{TRUE}.}

\item{steps}{A numeric value specifying the resolution of the plot, i.e., the number of rows for the square matrix, which also represents the number of grid points per factor.
By default, \code{steps} is set to 25.}

\item{plot}{Logical value indicating whether to display the plot. Default is \code{TRUE}.}

\item{show.scale}{Logical value indicating whether to display the color scale on the plot. Default is \code{TRUE}.}
}
\value{
The function \code{contourPlot3} returns an invisible list containing:
\itemize{
 \item{mat - A matrix containing the response values as NA's and numerics.}
 \item{plot - The generated plot.}
}
}
\description{
This function creates a ternary plot (contour plot) for mixture designs (i.e. object of class \code{mixDesign}).
}
\examples{
mdo = mixDesign(3,2, center = FALSE, axial = FALSE, randomize = FALSE,
                replicates  = c(1,1,2,3))
mdo$names(c("polyethylene", "polystyrene", "polypropylene"))
mdo$units("percent")
elongation = c(11.0, 12.4, 15.0, 14.8, 16.1, 17.7, 16.4, 16.6, 8.8, 10.0, 10.0,
               9.7, 11.8, 16.8, 16.0)
mdo$.response(elongation)
contourPlot3(A, B, C, elongation, data = mdo, form = "linear")
contourPlot3(A, B, C, elongation, data = mdo, form = "quadratic", col = 2)
contourPlot3(A, B, C, elongation, data = mdo,
             form = "elongation ~ I(A^2) - B:A + I(C^2)",
             col = 3, axes = FALSE)
contourPlot3(A, B, C, elongation, data = mdo,
             form = "quadratic",
             col = c("yellow", "white", "red"),
             axes = FALSE)
}
\seealso{
\code{\link{mixDesign.c}}, \code{\link{mixDesign}}, \code{\link{wirePlot3}}.
}
