% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4.3_Mix_designs_Functions.R
\name{wirePlot3}
\alias{wirePlot3}
\title{wirePlot3: function to create a ternary plot (3D wire plot)}
\usage{
wirePlot3(
  x,
  y,
  z,
  response,
  data = NULL,
  main,
  xlab,
  ylab,
  zlab,
  form = "linear",
  col = "Rainbow",
  steps,
  plot = TRUE
)
}
\arguments{
\item{x}{Factor 1 of the \code{mixDesign} object.}

\item{y}{Factor 2 of the \code{mixDesign} object.}

\item{z}{Factor 3 of the \code{mixDesign} object.}

\item{response}{the response of the \code{mixDesign} object.}

\item{data}{The \code{mixDesign} object from which x,y,z and the response are taken.}

\item{main}{Character string specifying the main title of the plot.}

\item{xlab}{Character string specifying the label for the x-axis.}

\item{ylab}{Character string specifying the label for the y-axis.}

\item{zlab}{Character string specifying the label for the z-axis.}

\item{form}{A character string or a formula with the syntax `y ~ A + B + C`.
If form is a character string, it has to be one of the following:
\itemize{
\item{`linear`}
\item{`quadratic`}
}
How the form influences the output is described in the reference listed below.
By default, \code{form} is set to `linear`.}

\item{col}{Character string specifying the color palette to use for the plot (e.g., \code{`Rainbow`}, \code{`Jet`}, \code{`Earth`}, \code{`Electric`}). Default is \code{`Rainbow`}.}

\item{steps}{A numeric value specifying the resolution of the plot, i.e., the number of rows for the square matrix, which also represents the number of grid points per factor.
By default, \code{steps} is set to 25.}

\item{plot}{Logical value indicating whether to display the plot. Default is \code{TRUE}.}
}
\value{
The function \code{wirePlot3} returns an invisible matrix containing the response values as NA's and numerics.
}
\description{
This function creates a ternary plot for mixture designs (i.e. object of class \code{mixDesign}).
}
\examples{
#Example 1
mdo <- mixDesign(3, 2, center = FALSE, axial = FALSE, randomize = FALSE, replicates = c(1, 1, 2, 3))
elongation <- c(11.0, 12.4, 15.0, 14.8, 16.1, 17.7,
                16.4, 16.6, 8.8, 10.0, 10.0, 9.7,
                11.8, 16.8, 16.0)
mdo$.response(elongation)
wirePlot3(A, B, C, elongation, data = mdo, form = "quadratic")

#Example 2
mdo <- mixDesign(3,2, center = FALSE, axial = FALSE, randomize = FALSE, replicates  = c(1,1,2,3))
mdo$names(c("polyethylene", "polystyrene", "polypropylene"))
mdo$units("percent")
elongation <- c(11.0, 12.4, 15.0, 14.8, 16.1, 17.7,
                16.4, 16.6, 8.8, 10.0, 10.0, 9.7,
                11.8, 16.8, 16.0)
mdo$.response(elongation)
wirePlot3(A, B, C, elongation, data = mdo, form = "linear")
wirePlot3(A, B, C, elongation, data = mdo, form = "quadratic",
           col = "Jet")
wirePlot3(A, B, C, elongation, data = mdo,
           form = "elongation ~ I(A^2) - B:A + I(C^2)",
           col = "Electric")
wirePlot3(A, B, C, elongation, data = mdo, form = "quadratic",
           col = "Earth")
}
\seealso{
\code{\link{mixDesign.c}}, \code{\link{mixDesign}}, \code{\link{contourPlot3}}.
}
