% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amBoxplotChart.R
\name{amBoxplotChart}
\alias{amBoxplotChart}
\title{HTML widget displaying a boxplot chart}
\usage{
amBoxplotChart(
  data,
  category,
  value,
  color = NULL,
  hline = NULL,
  yLimits = NULL,
  expandY = 5,
  valueFormatter = "#.",
  chartTitle = NULL,
  theme = NULL,
  animated = TRUE,
  tooltip = TRUE,
  bullets = NULL,
  backgroundColor = NULL,
  xAxis = NULL,
  yAxis = NULL,
  scrollbarX = FALSE,
  scrollbarY = FALSE,
  caption = NULL,
  image = NULL,
  cursor = FALSE,
  width = NULL,
  height = NULL,
  export = FALSE,
  chartId = NULL,
  elementId = NULL
)
}
\arguments{
\item{data}{a dataframe}

\item{category}{name of the column of \code{data} to be used for the
category axis; this can be a date column}

\item{value}{name of the column of \code{data} to be used for the
value axis}

\item{color}{the color of the boxplots; it can be given by the name of a R
color, the name of a CSS color, e.g. \code{"crimson"} or \code{"fuchsia"},
a HEX code like \code{"#FF009A"}, a RGB code like
\code{"rgb(255,100,39)"}, or a HSL code like \code{"hsl(360,11,255)"}}

\item{hline}{an optional horizontal line to add to the chart; it must be a
named list of the form \code{list(value = h, line = settings)} where
\code{h} is the "intercept" and \code{settings} is a list of settings
created with \code{\link{amLine}}}

\item{yLimits}{range of the y-axis, a vector of two values specifying
the lower and the upper limits of the y-axis; \code{NULL} for default values}

\item{expandY}{if \code{yLimits = NULL}, a percentage of the range of the
y-axis used to expand this range}

\item{valueFormatter}{a
\href{https://www.amcharts.com/docs/v4/concepts/formatters/formatting-numbers/}{number formatting string};
it is used to format the values displayed in the cursor tooltips,
the labels of the y-axis unless you specify
your own formatter in the \code{labels} field of the list passed on to
the \code{yAxis} option, and the values displayed in the tooltips unless
you specify your own tooltip text (see the first example of
\code{\link{amBarChart}} for the way to set
a number formatter in the tooltip text)}

\item{chartTitle}{chart title, it can be \code{NULL} or \code{FALSE} for no
title, a character string,
a list of settings created with \code{\link{amText}}, or a list with two
fields: \code{text}, a list of settings created with \code{\link{amText}},
and \code{align}, can be \code{"left"}, \code{"right"} or \code{"center"}}

\item{theme}{theme, \code{NULL} or one of \code{"dataviz"},
\code{"material"}, \code{"kelly"}, \code{"dark"}, \code{"moonrisekingdom"},
\code{"frozen"}, \code{"spiritedaway"}, \code{"patterns"},
\code{"microchart"}}

\item{animated}{Boolean, whether to animate the rendering of the graphic}

\item{tooltip}{\code{TRUE} for the default tooltips,
\code{FALSE} for no tooltip, otherwise a string for the text to
display in the tooltip}

\item{bullets}{settings of the bullets representing the outliers;
\code{NULL} for default, otherwise a list created with
\code{\link{amCircle}}, \code{\link{amTriangle}} or
\code{\link{amRectangle}}}

\item{backgroundColor}{a color for the chart background; it can be
given by the name of a R color, the name of a CSS color, e.g.
\code{"lime"} or \code{"olive"}, an HEX code like
\code{"#ff009a"}, a RGB code like \code{"rgb(255,100,39)"}, or a HSL code
like \code{"hsl(360,11,255)"}}

\item{xAxis}{settings of the category axis given as a list, or just a string
for the axis title; the list of settings has four possible fields:
a field \code{title}, a list of settings for the axis title created
with \code{\link{amText}},
a field \code{labels}, a list of settings for the axis labels created
with \code{\link{amAxisLabels}},
a field \code{adjust}, a number defining the vertical adjustment of
the axis (in pixels), and
a field \code{gridLines}, a list of settings for
the grid lines created with \code{\link{amLine}}}

\item{yAxis}{settings of the value axis given as a list, or just a string
for the axis title; the list of settings has five possible fields:
a field \code{title}, a list of settings for the axis title created
with \code{\link{amText}},
a field \code{labels}, a list of settings for the axis labels created
with \code{\link{amAxisLabels}},
a field \code{adjust}, a number defining the horizontal adjustment of
the axis (in pixels),
a field \code{gridLines}, a list of settings for
the grid lines created with \code{\link{amLine}} and
a field \code{breaks} to control the axis breaks, an R object created with
\code{\link{amAxisBreaks}}}

\item{scrollbarX}{logical, whether to add a scrollbar for the category axis}

\item{scrollbarY}{logical, whether to add a scrollbar for the value axis}

\item{caption}{\code{NULL} or \code{FALSE} for no caption, a formatted
text created with \code{\link{amText}}, or a list with two fields:
\code{text}, a list created with \code{\link{amText}}, and \code{align},
can be \code{"left"}, \code{"right"} or \code{"center"}}

\item{image}{option to include an image at a corner of the chart;
\code{NULL} or \code{FALSE} for no image, otherwise a named list with four
possible fields: the field \code{image} (required) is a list created with
\code{\link{amImage}},
the field \code{position} can be \code{"topleft"}, \code{"topright"},
\code{"bottomleft"} or \code{"bottomright"}, the field \code{hjust}
defines the horizontal adjustment, and the field \code{vjust} defines
the vertical adjustment}

\item{cursor}{option to add a cursor on the chart; \code{FALSE} for no
cursor, \code{TRUE} for a cursor with default settings for the tooltips,
or a list of settings created with \code{\link{amTooltip}} to
set the style of the tooltips, or a list with three possible fields:
a field \code{tooltip}, a list of tooltip settings created with
\code{\link{amTooltip}}, a field
\code{extraTooltipPrecision}, an integer, the number of additional
decimals to display in the tooltips, and a field \code{modifier},
which defines a modifier for the
values displayed in the tooltips; a modifier is some JavaScript code
given as a string, which performs a modification of a string named
\code{text}, e.g. \code{modifier = "text = '>>>' + text;"}}

\item{width}{the width of the chart, e.g. \code{"600px"} or \code{"80\%"};
ignored if the chart is displayed in Shiny, in which case the width is
given in \code{\link{amChart4Output}}}

\item{height}{the height of the chart, e.g. \code{"400px"};
ignored if the chart is displayed in Shiny, in which case the height is
given in \code{\link{amChart4Output}}}

\item{export}{logical, whether to enable the export menu}

\item{chartId}{a HTML id for the chart}

\item{elementId}{a HTML id for the container of the chart; ignored if the
chart is displayed in Shiny, in which case the id is given by the Shiny id}
}
\description{
Create a HTML widget displaying a boxplot chart.
}
\examples{
library(rAmCharts4)
set.seed(666)
dat <- data.frame(
  group = gl(4, 50, labels = c("A", "B", "C", "D")),
  y     = rt(200, df = 3)
)
amBoxplotChart(
  dat,
  category = "group",
  value = "y",
  color = "maroon",
  valueFormatter = "#.#",
  theme = "moonrisekingdom"
)
}
