% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XYZ2DTM.R
\name{XYZ2DTM}
\alias{XYZ2DTM}
\title{XYZ2DTM}
\usage{
XYZ2DTM(
  fusion.path = "C:/FUSION/",
  surfacefile,
  xyunits,
  zunits,
  coordsys,
  zone,
  horizdatum,
  vertdatum,
  datafile1,
  datafile2 = NULL,
  switches = FALSE
)
}
\arguments{
\item{fusion.path}{Character. By default: C:/FUSION/. Path where the program FUSION is installed.}

\item{surfacefile}{is a character.Name for output canopy surface file (stored in PLANS DTM format with .dtm extension).}

\item{xyunits}{Character. Units for LIDAR data XY:
\itemize{
\item M - for meters.
\item F - for feet.
}}

\item{zunits}{Character. Units for LIDAR data elevations:
\itemize{
\item M - for meters.
\item F - for feet.
}}

\item{coordsys}{Numeric. Coordinate system for the canopy model:
\itemize{
\item 0 - for unknown.
\item 1 - for UTM.
\item 2 - for state plane.
}}

\item{zone}{Numeric.. Coordinate system zone for the canopy model (0 for unknown).}

\item{horizdatum}{is a numeric. Horizontal datum for the canopy model.
\itemize{
\item 0 - for unknown.
\item 1 - for NAD27.
\item 2 -for NAD83.
}}

\item{vertdatum}{Character..Vertical datum for the surface
\itemize{
\item 0 - for unknown.
\item 1 - for NGVD29.
\item 2 -for NAVD88.
\item 3 -for GRS80.
}}

\item{datafile1}{Character. First XYZ point file...may be wildcard or text list file (extension .txt only)...omit other datafile# parameters.
Second XYZ point file.}

\item{datafile2}{Character.NULL by default. Second XYZ point file.
Several point files can be specified. The limit depends on the length of each file name. When using multiple data files, it is best to use a wildcard for datafile1 or create a text file containing a list of the data files and specifying the list file as datafile1.}

\item{switches}{False as default. To insert a switch, it must have a '/' before of the names. If you want to insert two or more switches, they must be separated by an empty space. When a # is displayed, should be replaced by the desired value (numeric).

\itemize{
\item /csv - Input files are in CSV format, skip first line when reading.
\item /fillholes:# - Fill holes (NODATA areas) in the final surface model that are up to # by # cells. Larger holes will not be filled
}}
}
\value{
No return value. This function return the command prompt running the FUSION command
}
\description{
XYZ2DTM converts surface models stored as ACSII XYZ point files into the PLANS DTM format. Input point files include one record for each grid point with the X, Y, and elevation values separated by commas, spaces, or tabs.
In general, this utility is only used when surface models are delivered in this format. FUSION provides the ability to export a PLANS DTM model in XYZ point format but this format is not the most efficient in terms of storage space.
In addition, most GIS packages cannot directly convert this format into a surface model.
They often use the XYZ points as if they were random XYZ data and interpolate a new grid using the point data. XYZ2DTM offers an optional switch to fill void areas by interpolating from surrounding grid elevations.
}
\details{
XYZ2DTM scans all data files to determine the extent of the final surface model and the grid cell size. XYZ data files should be ordered in either rows or columns for the cell size detection logic to work correctly.
XYZ2DTM will not work with random XYZ point data. Prior to populating the surface with grid elevations, all grid points are initialized to indicate NODATA (value of -1.0). As XYZ point files are read and processed, grid cell elevations are inserted into the appropriate row/column location. After all XYZ point files have been processed, the model is written using the PLANS DTM file format with floating point elevation values.\cr
When the /fillholes:# switch is specified. Void areas in the final surface are filled by interpolating values from adjacent grid cells. The parameter, #, specifies the largest distance that will be searched for valid point elevations. In operation, the void filling logic searches in eight directions to find valid grid point elevations to use in the interpolation.
If four or more of the directional searches find a valid elevation, the hole is filled using the average of all the values.
}
\examples{
surfacefile<-'Z:/dtmfile.dtm'
datafile1<- 'Z:/datafile1.xyz'
XYZ2DTM(surfacefile = surfacefile,xyunits = 'M',zunits = 'M',
          coordsys = 1,zone = 0, horizdatum = 0, vertdatum = 0,
                    datafile1=datafile1, switches = FALSE)
}
\references{
McGaughey, R.J. FUSION/LDV: Software for LIDAR Data Analysis and Visualization. 2021.
}
